/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaDelete;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityRoot;
import io.micronaut.inject.ast.ClassElement;
import jakarta.persistence.criteria.CriteriaBuilder;
import java.util.function.Function;

@Internal
final class SourcePersistentEntityCriteriaDeleteImpl<T>
extends AbstractPersistentEntityCriteriaDelete<T>
implements SourcePersistentEntityCriteriaDelete<T> {
    private final Function<ClassElement, SourcePersistentEntity> entityResolver;
    private final CriteriaBuilder criteriaBuilder;

    SourcePersistentEntityCriteriaDeleteImpl(Function<ClassElement, SourcePersistentEntity> entityResolver, Class<T> result, CriteriaBuilder criteriaBuilder) {
        this.entityResolver = entityResolver;
        this.criteriaBuilder = criteriaBuilder;
    }

    @Override
    public PersistentEntityRoot<T> from(ClassElement entityClassElement) {
        return this.from(new SourcePersistentEntity(entityClassElement, this.entityResolver));
    }

    public PersistentEntityRoot<T> from(Class<T> entityClass) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public PersistentEntityRoot<T> from(PersistentEntity persistentEntity) {
        SourcePersistentEntityRoot newEntityRoot;
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        this.entityRoot = newEntityRoot = new SourcePersistentEntityRoot((SourcePersistentEntity)persistentEntity, this.criteriaBuilder);
        return newEntityRoot;
    }
}

