/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.mappers.jpa.jx;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.NonNull;

public class ColumnAnnotationMapper
implements NamedAnnotationMapper {
    public @NonNull String getName() {
        return "javax.persistence.Column";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        String name = annotation.stringValue("name").orElse(null);
        boolean nullable = annotation.booleanValue("nullable").orElse(false);
        ArrayList values = new ArrayList(2);
        if (name != null) {
            AnnotationValueBuilder builder = AnnotationValue.builder(MappedProperty.class).value(name);
            annotation.stringValue("columnDefinition").ifPresent(s -> builder.member("definition", s));
            AnnotationValue persistedAnnotationValue = builder.build();
            values.add(persistedAnnotationValue);
        } else {
            annotation.stringValue("columnDefinition").ifPresent(s -> values.add(AnnotationValue.builder(MappedProperty.class).member("definition", s).build()));
        }
        if (nullable) {
            values.add(AnnotationValue.builder((String)"javax.annotation.Nullable").build());
        }
        return values;
    }
}

