/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityJoinSupport;
import io.micronaut.data.processor.model.SourceAssociation;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentAssociationPath;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentPropertyPath;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentPropertyPathImpl;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Internal
abstract class AbstractSourcePersistentEntityJoinSupport<T, E>
extends AbstractPersistentEntityJoinSupport<T, E> {
    protected final CriteriaBuilder criteriaBuilder;

    AbstractSourcePersistentEntityJoinSupport(CriteriaBuilder criteriaBuilder) {
        this.criteriaBuilder = criteriaBuilder;
    }

    protected abstract List<Association> getCurrentPath();

    public abstract SourcePersistentEntity getPersistentEntity();

    public <Y> SourcePersistentPropertyPath<Y> get(String attributeName) {
        SourcePersistentProperty property = this.getPersistentEntity().getPropertyByName(attributeName);
        if (property == null) {
            throw new IllegalStateException("Cannot query entity [" + this.getPersistentEntity().getSimpleName() + "] on non-existent property: " + attributeName);
        }
        AbstractSourcePersistentEntityJoinSupport abstractSourcePersistentEntityJoinSupport = this;
        if (abstractSourcePersistentEntityJoinSupport instanceof PersistentAssociationPath) {
            PersistentAssociationPath associationPath = (PersistentAssociationPath)abstractSourcePersistentEntityJoinSupport;
            List associations = associationPath.getAssociations();
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
            newAssociations.addAll(associations);
            newAssociations.add(associationPath.getAssociation());
            return new SourcePersistentPropertyPathImpl((Path<?>)this, (List<Association>)newAssociations, property, this.criteriaBuilder);
        }
        return new SourcePersistentPropertyPathImpl((Path<?>)this, Collections.emptyList(), property, this.criteriaBuilder);
    }

    protected <Y> PersistentAssociationPath<E, Y> createJoinAssociation(Association association, Join.Type associationJoinType, String alias) {
        return new SourcePersistentAssociationPath(this, (SourceAssociation)association, this.getCurrentPath(), associationJoinType, alias, this.criteriaBuilder);
    }
}

