/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentEntityFrom;
import io.micronaut.data.processor.model.SourceAssociation;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.criteria.impl.AbstractSourcePersistentEntityJoinSupport;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityPath;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentPropertyPath;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import java.util.ArrayList;
import java.util.List;

@Internal
final class SourcePersistentAssociationPath<Owner, E>
extends AbstractSourcePersistentEntityJoinSupport<Owner, E>
implements SourcePersistentEntityPath<E>,
SourcePersistentPropertyPath<E>,
PersistentAssociationPath<Owner, E> {
    private final PersistentEntityFrom<?, Owner> parent;
    private final SourceAssociation association;
    private final List<Association> associations;
    private Join.Type associationJoinType;
    @Nullable
    private String alias;

    SourcePersistentAssociationPath(PersistentEntityFrom<?, Owner> parent, SourceAssociation association, List<Association> associations, Join.Type associationJoinType, String alias, CriteriaBuilder criteriaBuilder) {
        super(criteriaBuilder);
        this.parent = parent;
        this.association = association;
        this.associations = associations;
        this.associationJoinType = associationJoinType;
        this.alias = alias;
    }

    public PersistentEntityFrom<?, Owner> getParent() {
        return this.parent;
    }

    public Join.Type getAssociationJoinType() {
        return this.associationJoinType;
    }

    public void setAssociationJoinType(@Nullable Join.Type type) {
        this.associationJoinType = type;
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Path<?> getParentPath() {
        return this.parent;
    }

    @Override
    public SourceAssociation getProperty() {
        return this.association;
    }

    @Override
    public List<Association> getAssociations() {
        return this.associations;
    }

    public Association getAssociation() {
        return this.association;
    }

    @Override
    public SourcePersistentEntity getPersistentEntity() {
        return this.association.getAssociatedEntity();
    }

    @Override
    protected List<Association> getCurrentPath() {
        return SourcePersistentAssociationPath.associated(this.getAssociations(), this.association);
    }

    private static List<Association> associated(List<Association> associations, Association association) {
        ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
        newAssociations.addAll(associations);
        newAssociations.add(association);
        return newAssociations;
    }
}

