/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.criteria;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityQuery;
import io.micronaut.data.model.jpa.criteria.impl.QueryResultPersistentEntityCriteriaQuery;
import io.micronaut.data.model.query.builder.AbstractSqlLikeQueryBuilder;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaQuery;
import io.micronaut.data.processor.model.criteria.impl.MethodMatchSourcePersistentEntityCriteriaBuilderImpl;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractCriteriaMethodMatch;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class QueryCriteriaMethodMatch
extends AbstractCriteriaMethodMatch {
    public QueryCriteriaMethodMatch(List<MethodNameParser.Match> matches) {
        super(matches);
    }

    protected PersistentEntityCriteriaQuery<Object> createQuery(MethodMatchContext matchContext, PersistentEntityCriteriaBuilder cb, List<AnnotationValue<Join>> joinSpecs) {
        PersistentEntityCriteriaQuery<Object> criteriaQuery;
        Element paginationParameter = matchContext.getParametersInRole().get("pageable");
        boolean isPageable = matchContext.hasParameterInRole("pageable");
        SourcePersistentEntity persistentEntity = matchContext.getRootEntity();
        if (isPageable && this.isPageableWithJoins(persistentEntity, matchContext, joinSpecs)) {
            int pageableParameterIndex = List.of(matchContext.getParameters()).indexOf(paginationParameter);
            criteriaQuery = this.createQueryWithJoinsAndPagination(matchContext, cb, joinSpecs, pageableParameterIndex);
        } else {
            criteriaQuery = this.createDefaultQuery(matchContext, cb, joinSpecs);
            if (isPageable) {
                AbstractPersistentEntityQuery abstractPersistentEntityQuery = (AbstractPersistentEntityQuery)criteriaQuery;
                abstractPersistentEntityQuery.getParametersInRole().put("pageable", List.of(matchContext.getParameters()).indexOf(paginationParameter));
            } else if (matchContext.hasParameterInRole("sort")) {
                Element sortParameter = matchContext.getParametersInRole().get("sort");
                AbstractPersistentEntityQuery abstractPersistentEntityQuery = (AbstractPersistentEntityQuery)criteriaQuery;
                abstractPersistentEntityQuery.getParametersInRole().put("sort", List.of(matchContext.getParameters()).indexOf(sortParameter));
            }
        }
        return criteriaQuery;
    }

    private boolean isPageableWithJoins(SourcePersistentEntity persistentEntity, MethodMatchContext matchContext, List<AnnotationValue<Join>> joinSpecs) {
        SqlQueryBuilder queryBuilder;
        AbstractSqlLikeQueryBuilder sqlQueryBuilder;
        QueryBuilder queryBuilder2;
        return !joinSpecs.isEmpty() && (queryBuilder2 = matchContext.getQueryBuilder()) instanceof AbstractSqlLikeQueryBuilder && (!((sqlQueryBuilder = (AbstractSqlLikeQueryBuilder)queryBuilder2) instanceof SqlQueryBuilder) || (queryBuilder = (SqlQueryBuilder)sqlQueryBuilder).getDialect() != Dialect.MYSQL) && !persistentEntity.hasCompositeIdentity() && !(persistentEntity.getIdentity() instanceof Embedded);
    }

    private PersistentEntityCriteriaQuery<Object> createDefaultQuery(MethodMatchContext matchContext, PersistentEntityCriteriaBuilder cb, List<AnnotationValue<Join>> joinSpecs) {
        PersistentEntityCriteriaQuery query = cb.createQuery();
        PersistentEntityRoot root = query.from((PersistentEntity)matchContext.getRootEntity());
        this.applyDistinct((PersistentEntityCriteriaQuery<Object>)query);
        this.applyProjection(matchContext, cb, (PersistentEntityRoot<Object>)root, (PersistentEntityCriteriaQuery<Object>)query);
        this.applyPredicate(matchContext, cb, (PersistentEntityRoot<Object>)root, (PersistentEntityQuery<Object>)query);
        this.applyOrder(cb, (PersistentEntityRoot<Object>)root, (PersistentEntityQuery<Object>)query);
        this.applyForUpdate((PersistentEntityCriteriaQuery<Object>)query);
        this.applyLimit((PersistentEntityQuery<Object>)query);
        this.applyJoinSpecs(root, joinSpecs);
        return query;
    }

    private PersistentEntityCriteriaQuery<Object> createQueryWithJoinsAndPagination(MethodMatchContext matchContext, PersistentEntityCriteriaBuilder cb, List<AnnotationValue<Join>> joinSpecs, int pageableParameterIndex) {
        PersistentEntityCriteriaQuery mainQuery = cb.createQuery();
        PersistentEntityRoot mainRoot = mainQuery.from((PersistentEntity)matchContext.getRootEntity());
        PersistentEntitySubquery paginationSubquery = mainQuery.subquery(mainRoot.getExpressionType());
        PersistentEntityRoot paginationRoot = paginationSubquery.from((PersistentEntity)matchContext.getRootEntity());
        paginationSubquery.select((Expression)paginationRoot.id());
        AbstractPersistentEntityQuery abstractPersistentEntityQuery = (AbstractPersistentEntityQuery)paginationSubquery;
        abstractPersistentEntityQuery.getParametersInRole().put("pageableRequired", pageableParameterIndex);
        PersistentEntitySubquery filteredSubquery = paginationSubquery.subquery(mainRoot.getExpressionType());
        PersistentEntityRoot filteredRoot = filteredSubquery.from((PersistentEntity)matchContext.getRootEntity());
        filteredSubquery.select((Expression)filteredRoot.id());
        paginationSubquery.where((Expression)paginationRoot.id().in(new Expression[]{filteredSubquery}));
        mainQuery.where((Expression)mainRoot.id().in(new Expression[]{paginationSubquery}));
        this.applyProjection(matchContext, cb, (PersistentEntityRoot<Object>)mainRoot, (PersistentEntityCriteriaQuery<Object>)mainQuery);
        this.applyPredicate(matchContext, cb, (PersistentEntityRoot<Object>)filteredRoot, (PersistentEntityQuery<Object>)filteredSubquery);
        this.applyOrder(cb, (PersistentEntityRoot<Object>)filteredRoot, (PersistentEntityQuery<Object>)filteredSubquery);
        this.applyOrder(cb, (PersistentEntityRoot<Object>)mainRoot, (PersistentEntityQuery<Object>)mainQuery);
        this.applyForUpdate((PersistentEntityCriteriaQuery<Object>)mainQuery);
        this.applyLimit((PersistentEntityQuery<Object>)filteredSubquery);
        this.applyDistinct((PersistentEntityCriteriaQuery<Object>)mainQuery);
        this.applyJoinSpecs(filteredRoot, joinSpecs);
        this.applyJoinSpecs(mainRoot, joinSpecs);
        AbstractPersistentEntityQuery mainEntityQuery = (AbstractPersistentEntityQuery)mainQuery;
        mainEntityQuery.getParametersInRole().put("sort", pageableParameterIndex);
        return mainQuery;
    }

    protected final PersistentEntityCriteriaQuery<Object> createDefaultCountQuery(MethodMatchContext matchContext, PersistentEntityCriteriaBuilder cb, List<AnnotationValue<Join>> joinSpecs) {
        PersistentEntityCriteriaQuery query = cb.createQuery();
        PersistentEntityRoot root = query.from((PersistentEntity)matchContext.getRootEntity());
        query.select((Selection)cb.count((Expression)root));
        this.applyPredicate(matchContext, cb, (PersistentEntityRoot<Object>)root, (PersistentEntityQuery<Object>)query);
        boolean distinct = !joinSpecs.isEmpty() || this.findMatchPart(this.matches, QueryMatchId.DISTINCT).isPresent();
        String projectionPart = this.findMatchPart(this.matches, QueryMatchId.PROJECTION).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)projectionPart)) {
            Expression<Object> propertyPath = this.getProperty(root, projectionPart);
            Expression count = distinct ? cb.countDistinct(propertyPath) : cb.count(propertyPath);
            query.select((Selection)count);
        } else {
            Expression count = distinct ? cb.countDistinct((Expression)root) : cb.count((Expression)root);
            query.select((Selection)count);
        }
        this.applyJoinSpecs(root, joinSpecs);
        return query;
    }

    private void applyForUpdate(PersistentEntityCriteriaQuery<Object> query) {
        this.findMatchPart(this.matches, QueryMatchId.FOR_UPDATE).ifPresent(text -> query.forUpdate(true));
    }

    private void applyOrder(PersistentEntityCriteriaBuilder cb, PersistentEntityRoot<Object> root, PersistentEntityQuery<Object> query) {
        this.findMatchPart(this.matches, QueryMatchId.ORDER).ifPresent(text -> this.applyOrderBy((String)text, root, query, cb));
    }

    private void applyDistinct(PersistentEntityCriteriaQuery<Object> mainQuery) {
        this.findMatchPart(this.matches, QueryMatchId.DISTINCT).ifPresent(text -> this.setDistinct(mainQuery));
    }

    private void applyLimit(PersistentEntityQuery<Object> query) {
        this.findMatchPart(this.matches, QueryMatchId.LIMIT).ifPresent(text -> {
            try {
                int max;
                int n = max = StringUtils.isNotEmpty((CharSequence)text) ? Integer.parseInt(text) : 1;
                if (max > -1) {
                    query.limit(max);
                }
            }
            catch (NumberFormatException e) {
                throw new MatchFailedException("Invalid number specified to top: " + text);
            }
        });
        this.findMatchPart(this.matches, QueryMatchId.FIRST).ifPresent(text -> query.limit(1));
    }

    private void applyPredicate(MethodMatchContext matchContext, PersistentEntityCriteriaBuilder cb, PersistentEntityRoot<Object> root, PersistentEntityQuery<Object> entityQuery) {
        this.findMatchPart(this.matches, QueryMatchId.PREDICATE).ifPresentOrElse(text -> this.applyPredicates(matchContext, (String)text, matchContext.getParameters(), (PersistentEntityRoot)root, entityQuery, cb), () -> this.applyPredicates(matchContext, matchContext.getParametersNotInRole(), root, entityQuery, cb));
    }

    private void applyProjection(MethodMatchContext matchContext, PersistentEntityCriteriaBuilder cb, PersistentEntityRoot<Object> root, PersistentEntityCriteriaQuery<Object> criteriaQuery) {
        this.findMatchPart(this.matches, QueryMatchId.PROJECTION).ifPresentOrElse(text -> this.applyProjections(matchContext, (String)text, (PersistentEntityRoot)root, (PersistentEntityCriteriaQuery)criteriaQuery, cb), () -> this.applyProjections(matchContext, "", root, criteriaQuery, cb));
    }

    private Optional<String> findMatchPart(List<MethodNameParser.Match> matches, QueryMatchId id) {
        return matches.stream().filter(match -> match.id() == id).findFirst().map(MethodNameParser.Match::part);
    }

    private <T> void applyPredicates(MethodMatchContext matchContext, String querySequence, ParameterElement[] parameters, PersistentEntityRoot<T> root, PersistentEntityQuery<?> query, PersistentEntityCriteriaBuilder cb) {
        Predicate predicate = this.extractPredicates(querySequence, Arrays.asList(parameters).iterator(), root, cb);
        predicate = this.interceptPredicate(matchContext, List.of(), root, cb, predicate);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
    }

    private <T> void applyPredicates(MethodMatchContext matchContext, List<ParameterElement> parameters, PersistentEntityRoot<T> root, PersistentEntityQuery<?> query, PersistentEntityCriteriaBuilder cb) {
        Predicate predicate = this.extractPredicates(parameters, root, cb);
        predicate = this.interceptPredicate(matchContext, List.of(), root, cb, predicate);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
    }

    protected <T> void setDistinct(PersistentEntityCriteriaQuery<T> query) {
        if (query.isDistinct()) {
            throw new MatchFailedException("Distinct already specified!");
        }
        query.distinct(true);
    }

    @Override
    protected MethodMatchInfo build(MethodMatchContext matchContext) {
        List<SourcePersistentProperty> dtoProjectionProperties;
        MethodMatchSourcePersistentEntityCriteriaBuilderImpl cb = new MethodMatchSourcePersistentEntityCriteriaBuilderImpl(matchContext);
        List<AnnotationValue<Join>> joinSpecs = this.joinSpecsAtMatchContext(matchContext, true);
        SourcePersistentEntity persistentEntity = matchContext.getRootEntity();
        PersistentEntityCriteriaQuery<Object> criteriaQuery = this.createQuery(matchContext, cb, joinSpecs);
        FindersUtils.InterceptorMatch interceptorMatch = this.resolveReturnTypeAndInterceptor(matchContext);
        ClassElement resultType = interceptorMatch.returnType();
        ClassElement interceptorType = interceptorMatch.interceptor();
        boolean optimisticLock = ((AbstractPersistentEntityCriteriaQuery)criteriaQuery).hasVersionRestriction();
        SourcePersistentEntityCriteriaQuery query = (SourcePersistentEntityCriteriaQuery)criteriaQuery;
        AbstractCriteriaMethodMatch.MethodResult result = this.analyzeMethodResult(matchContext, query.getQueryResultTypeName(), persistentEntity.getClassElement(), interceptorMatch, false);
        if (result.isDto() && !result.isRuntimeDtoConversion() && !(dtoProjectionProperties = this.getDtoProjectionProperties(persistentEntity, resultType)).isEmpty()) {
            Root root = (Root)query.getRoots().iterator().next();
            List selectionList = dtoProjectionProperties.stream().map(p -> {
                if (matchContext.getQueryBuilder().shouldAliasProjections()) {
                    return root.get(p.getName()).alias(p.getName());
                }
                return root.get(p.getName());
            }).collect(Collectors.toList());
            query.multiselect(selectionList);
        }
        MethodElement annotationMetadata = matchContext.getMethodElement();
        QueryResult queryResult = ((QueryResultPersistentEntityCriteriaQuery)criteriaQuery).buildQuery((AnnotationMetadata)annotationMetadata, matchContext.getQueryBuilder());
        ClassElement genericReturnType = matchContext.getReturnType();
        if (TypeUtils.isReactiveOrFuture(genericReturnType)) {
            genericReturnType = genericReturnType.getFirstTypeArgument().orElse(persistentEntity.getType());
        }
        boolean isReturnsPage = matchContext.isTypeInRole(genericReturnType, "page") || matchContext.isTypeInRole(genericReturnType, "cursoredPage");
        QueryResult countQueryResult = null;
        if (isReturnsPage) {
            PersistentEntityCriteriaQuery<Object> countQuery = this.createDefaultCountQuery(matchContext, cb, joinSpecs);
            countQueryResult = ((QueryResultPersistentEntityCriteriaQuery)countQuery).buildQuery((AnnotationMetadata)annotationMetadata, matchContext.getQueryBuilder());
        }
        return new MethodMatchInfo(this.getOperationType(), (TypedElement)result.resultType(), interceptorType).dto(result.isDto()).optimisticLock(optimisticLock).queryResult(queryResult).countQueryResult(countQueryResult);
    }

    private void applyOrderBy(String orderBy, PersistentEntityRoot<?> root, PersistentEntityQuery<?> query, PersistentEntityCriteriaBuilder cb) {
        String[] orderDefItems = orderBy.split("And");
        ArrayList<Order> orders = new ArrayList<Order>(orderDefItems.length);
        for (String orderDef : orderDefItems) {
            String propertyName;
            String prop = NameUtils.decapitalize((String)orderDef);
            if (prop.endsWith("Desc")) {
                propertyName = prop.substring(0, prop.length() - 4);
                orders.add(cb.desc(this.findOrderProperty(root, propertyName)));
                continue;
            }
            if (prop.endsWith("Asc")) {
                propertyName = prop.substring(0, prop.length() - 3);
                orders.add(cb.asc(this.findOrderProperty(root, propertyName)));
                continue;
            }
            orders.add(cb.asc(this.findOrderProperty(root, prop)));
        }
        if (!orders.isEmpty()) {
            query.orderBy(orders);
        }
    }

    private <T> PersistentPropertyPath<?> findOrderProperty(PersistentEntityRoot<T> root, String propertyName) {
        if (root.getPersistentEntity().getPropertyByName(propertyName) != null) {
            return root.get(propertyName);
        }
        PersistentPropertyPath<Object> property = this.findProperty(root, propertyName);
        if (property != null) {
            return property;
        }
        throw new MatchFailedException("Cannot order by non-existent property: " + propertyName);
    }

    private <T> void applyProjections(MethodMatchContext matchContext, String projection, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, PersistentEntityCriteriaBuilder cb) {
        this.applyProjections(projection, root, query, cb, matchContext.getReturnType().getSimpleName());
    }

    protected <T> void applyProjections(String projectionPart, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, PersistentEntityCriteriaBuilder cb, String returnTypeName) {
        List<Selection<?>> selectionList = this.findSelections(projectionPart, root, cb, returnTypeName);
        if (selectionList.isEmpty()) {
            return;
        }
        if (selectionList.size() == 1) {
            query.select(selectionList.iterator().next());
        } else {
            query.multiselect(selectionList);
        }
    }

    @Override
    protected DataMethod.OperationType getOperationType() {
        return DataMethod.OperationType.QUERY;
    }
}

