/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.data.intercept.FindByIdInterceptor;
import io.micronaut.data.intercept.FindOneInterceptor;
import io.micronaut.data.intercept.async.FindByIdAsyncInterceptor;
import io.micronaut.data.intercept.async.FindOneAsyncInterceptor;
import io.micronaut.data.intercept.reactive.FindByIdReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindOneReactiveInterceptor;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.criteria.QueryCriteriaMethodMatch;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import java.util.regex.Matcher;

@Internal
public final class FindMethodMatcher
extends AbstractPatternMethodMatcher {
    public FindMethodMatcher() {
        super(true, "find", "get", "query", "retrieve", "read", "search");
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        if (this.isCompatibleReturnType(matchContext)) {
            return new QueryCriteriaMethodMatch(matcher){
                boolean hasIdMatch;

                @Override
                protected <T> void apply(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                    super.apply(matchContext, root, query, cb);
                    if (query instanceof AbstractPersistentEntityCriteriaQuery) {
                        this.hasIdMatch = ((AbstractPersistentEntityCriteriaQuery)query).hasOnlyIdRestriction();
                    }
                }

                @Override
                protected FindersUtils.InterceptorMatch resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
                    FindersUtils.InterceptorMatch e = super.resolveReturnTypeAndInterceptor(matchContext);
                    ClassElement interceptorType = e.interceptor();
                    ClassElement queryResultType = e.returnType();
                    if (this.isFindByIdQuery(matchContext, queryResultType)) {
                        if (interceptorType.isAssignable(FindOneInterceptor.class)) {
                            interceptorType = (ClassElement)matchContext.getVisitorContext().getClassElement(FindByIdInterceptor.class).orElseThrow();
                        } else if (interceptorType.isAssignable(FindOneAsyncInterceptor.class)) {
                            interceptorType = (ClassElement)matchContext.getVisitorContext().getClassElement(FindByIdAsyncInterceptor.class).orElseThrow();
                        } else if (interceptorType.isAssignable(FindOneReactiveInterceptor.class)) {
                            interceptorType = (ClassElement)matchContext.getVisitorContext().getClassElement(FindByIdReactiveInterceptor.class).orElseThrow();
                        }
                        return new FindersUtils.InterceptorMatch(queryResultType, interceptorType);
                    }
                    return e;
                }

                private boolean isFindByIdQuery(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType) {
                    return this.hasIdMatch && matchContext.supportsImplicitQueries() && queryResultType.getName().equals(matchContext.getRootEntity().getName()) && this.hasNoWhereAndJoinDeclaration(matchContext);
                }
            };
        }
        return null;
    }

    private boolean isCompatibleReturnType(@NonNull MatchContext matchContext) {
        MethodElement methodElement = matchContext.getMethodElement();
        ClassElement returnType = TypeUtils.getMethodProducingItemType(methodElement);
        if (returnType == null) {
            return false;
        }
        if (FindersUtils.isFindAllCompatibleReturnType(matchContext)) {
            return true;
        }
        if (!TypeUtils.isVoid(returnType)) {
            return returnType.hasStereotype(Introspected.class) || returnType.isPrimitive() || ClassUtils.isJavaBasicType((String)returnType.getName()) || TypeUtils.isContainerType(returnType);
        }
        ClassElement genericReturnType = methodElement.getGenericReturnType();
        return matchContext.isTypeInRole(genericReturnType, "page") || matchContext.isTypeInRole(genericReturnType, "slice");
    }
}

