/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.spec;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractSpecificationMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Map;
import java.util.regex.Matcher;

@Internal
public class FindPageSpecificationMethodMatcher
extends AbstractSpecificationMethodMatcher {
    public FindPageSpecificationMethodMatcher() {
        super("get", "find", "search", "query");
    }

    @Override
    public int getOrder() {
        return -301;
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        ClassElement returnType = TypeUtils.getMethodProducingItemType(matchContext.getMethodElement());
        if (returnType != null && (returnType.isAssignable("org.springframework.data.domain.Page") || returnType.isAssignable("io.micronaut.data.model.Page")) && this.areParametersValid(matchContext.getMethodElement())) {
            if (this.isFirstParameterMicronautDataQuerySpecification(matchContext.getMethodElement())) {
                Map.Entry<ClassElement, ClassElement> e = FindersUtils.pickFindPageSpecInterceptor(matchContext, matchContext.getReturnType());
                return mc -> new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)e.getKey(), (ClassElement)e.getValue());
            }
            if (this.isFirstParameterSpringJpaSpecification(matchContext.getMethodElement())) {
                return mc -> new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)mc.getReturnType(), this.getInterceptorElement(mc, "io.micronaut.data.spring.jpa.intercept.FindPageSpecificationInterceptor"));
            }
            return mc -> {
                ClassElement classElement = this.getInterceptorElement(mc, "io.micronaut.data.jpa.repository.intercept.FindPageSpecificationInterceptor");
                return new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)mc.getReturnType(), classElement);
            };
        }
        return null;
    }

    private boolean areParametersValid(@NonNull MethodElement methodElement) {
        ParameterElement[] parameters = methodElement.getParameters();
        int len = parameters.length;
        if (len != 2) {
            return false;
        }
        return parameters[1].getType().isAssignable("org.springframework.data.domain.Pageable") || parameters[1].getType().isAssignable("io.micronaut.data.model.Pageable");
    }

    @Override
    protected boolean isMatchesParameters(MethodMatchContext matchContext) {
        return super.isMatchesParameters(matchContext) || this.isFirstParameterMicronautDataQuerySpecification(matchContext.getMethodElement());
    }
}

