/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.criteria;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.QueryModelPersistentEntityCriteriaQuery;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaQuery;
import io.micronaut.data.processor.model.criteria.impl.MethodMatchSourcePersistentEntityCriteriaBuilderImpl;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractCriteriaMethodMatch;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.Projections;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.TypedElement;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class QueryCriteriaMethodMatch
extends AbstractCriteriaMethodMatch {
    private static final String[] ORDER_VARIATIONS = new String[]{"Order", "Sort"};
    private static final String BY = "By";
    private static final Pattern ORDER_BY_PATTERN = Pattern.compile("(.*)(" + Arrays.stream(ORDER_VARIATIONS).map(o -> o + BY).collect(Collectors.joining("|")) + ")([\\w\\d]+)");

    public QueryCriteriaMethodMatch(Matcher matcher) {
        super(matcher);
    }

    protected <T> void apply(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        if (this.matcher.groupCount() == 4) {
            String projectionSequence = this.matcher.group(3);
            String querySequence = this.matcher.group(4);
            for (String orderVariation : ORDER_VARIATIONS) {
                if (!projectionSequence.endsWith(orderVariation) || !matchContext.getMethodElement().getName().contains(orderVariation + BY + querySequence)) continue;
                this.apply(matchContext, root, query, cb, projectionSequence + BY + querySequence);
                return;
            }
            this.apply(matchContext, root, query, cb, projectionSequence, querySequence);
        } else if (this.matcher.group(2).endsWith(BY)) {
            this.apply(matchContext, root, query, cb, "", this.matcher.group(3));
        } else {
            String querySequence = this.matcher.group(3);
            this.apply(matchContext, root, query, cb, querySequence);
        }
    }

    private <T> void apply(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, SourcePersistentEntityCriteriaBuilder cb, String projectionSequence) {
        this.applyPredicates(matchContext.getParametersNotInRole(), root, query, cb);
        projectionSequence = this.applyForUpdate(projectionSequence, query);
        projectionSequence = this.applyOrderBy(projectionSequence, root, query, cb);
        projectionSequence = this.applyProjections(projectionSequence, root, query, cb);
        this.applyProjectionLimits(projectionSequence, matchContext, query);
        this.applyJoinSpecs(root, this.joinSpecsAtMatchContext(matchContext, true));
    }

    private <T> void apply(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, SourcePersistentEntityCriteriaBuilder cb, String projectionSequence, String querySequence) {
        projectionSequence = this.applyProjections(projectionSequence, root, query, cb);
        this.applyProjectionLimits(projectionSequence, matchContext, query);
        querySequence = this.applyForUpdate(querySequence, query);
        querySequence = this.applyOrderBy(querySequence, root, query, cb);
        this.applyPredicates(querySequence, matchContext.getParameters(), root, query, cb);
        this.applyJoinSpecs(root, this.joinSpecsAtMatchContext(matchContext, true));
    }

    @Override
    protected MethodMatchInfo build(MethodMatchContext matchContext) {
        ClassElement queryResultType = matchContext.getRootEntity().getClassElement();
        MethodMatchSourcePersistentEntityCriteriaBuilderImpl cb = new MethodMatchSourcePersistentEntityCriteriaBuilderImpl(matchContext);
        PersistentEntityCriteriaQuery criteriaQuery = cb.createQuery();
        this.apply(matchContext, criteriaQuery.from((PersistentEntity)matchContext.getRootEntity()), criteriaQuery, cb);
        Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = this.resolveReturnTypeAndInterceptor(matchContext);
        ClassElement resultType = entry.getKey();
        Class<? extends DataInterceptor> interceptorType = entry.getValue();
        boolean optimisticLock = ((AbstractPersistentEntityCriteriaQuery)criteriaQuery).hasVersionRestriction();
        SourcePersistentEntityCriteriaQuery query = (SourcePersistentEntityCriteriaQuery)criteriaQuery;
        String selectedType = query.getQueryResultTypeName();
        if (selectedType != null && (queryResultType = (ClassElement)matchContext.getVisitorContext().getClassElement(selectedType).orElse(null)) == null) {
            try {
                queryResultType = PrimitiveElement.valueOf((String)selectedType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean isDto = resultType != null && !TypeUtils.areTypesCompatible(resultType, queryResultType) && (this.isDtoType(matchContext.getRepositoryClass(), resultType) || resultType.hasStereotype(Introspected.class) && queryResultType.hasStereotype(MappedEntity.class));
        ClassElement finalResultType = resultType;
        if (isDto) {
            List<SourcePersistentProperty> dtoProjectionProperties;
            if (!this.isDtoType(matchContext.getRepositoryClass(), resultType) && !(dtoProjectionProperties = this.getDtoProjectionProperties(matchContext.getRootEntity(), resultType)).isEmpty()) {
                Root root = (Root)query.getRoots().iterator().next();
                query.multiselect(dtoProjectionProperties.stream().map(p -> {
                    if (matchContext.getQueryBuilder().shouldAliasProjections()) {
                        return root.get(p.getName()).alias(p.getName());
                    }
                    return root.get(p.getName());
                }).collect(Collectors.toList()));
            }
        } else if (Arrays.stream(matchContext.getRepositoryClass().stringValues(RepositoryConfiguration.class, "queryReturnTypes")).noneMatch(type -> finalResultType.getName().equals(type)) && (resultType == null || !resultType.isAssignable(Void.TYPE) && !resultType.isAssignable(Void.class))) {
            if (resultType == null || TypeUtils.areTypesCompatible(resultType, queryResultType)) {
                if (!queryResultType.isPrimitive() || resultType == null) {
                    resultType = queryResultType;
                }
            } else {
                throw new MatchFailedException("Query results in a type [" + queryResultType.getName() + "] whilst method returns an incompatible type: " + resultType.getName());
            }
        }
        AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass().getAnnotationMetadata(), matchContext.getAnnotationMetadata()});
        QueryBuilder queryBuilder = matchContext.getQueryBuilder();
        QueryModel queryModel = ((QueryModelPersistentEntityCriteriaQuery)criteriaQuery).getQueryModel();
        QueryResult queryResult = queryBuilder.buildQuery((AnnotationMetadata)annotationMetadataHierarchy, queryModel);
        ClassElement genericReturnType = matchContext.getReturnType();
        if (TypeUtils.isReactiveOrFuture(genericReturnType)) {
            genericReturnType = genericReturnType.getFirstTypeArgument().orElse(matchContext.getRootEntity().getType());
        }
        QueryResult countQueryResult = null;
        if (matchContext.isTypeInRole(genericReturnType, "page")) {
            QueryModel countQuery = QueryModel.from((PersistentEntity)queryModel.getPersistentEntity());
            countQuery.projections().count();
            QueryModel.Junction junction = queryModel.getCriteria();
            for (QueryModel.Criterion criterion : junction.getCriteria()) {
                countQuery.add(criterion);
            }
            for (JoinPath joinPath : queryModel.getJoinPaths()) {
                Association association = joinPath.getAssociation();
                if (association != null && !association.getKind().isSingleEnded()) continue;
                Join.Type joinType = joinPath.getJoinType();
                switch (joinType) {
                    case INNER: 
                    case FETCH: {
                        joinType = Join.Type.DEFAULT;
                        break;
                    }
                    case LEFT_FETCH: {
                        joinType = Join.Type.LEFT;
                        break;
                    }
                    case RIGHT_FETCH: {
                        joinType = Join.Type.RIGHT;
                        break;
                    }
                }
                countQuery.join(joinPath.getPath(), joinType, null);
            }
            countQueryResult = queryBuilder.buildQuery((AnnotationMetadata)annotationMetadataHierarchy, countQuery);
        }
        return new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)resultType, this.getInterceptorElement(matchContext, interceptorType)).dto(isDto).optimisticLock(optimisticLock).queryResult(queryResult).countQueryResult(countQueryResult);
    }

    private boolean isDtoType(ClassElement repositoryElement, ClassElement classElement) {
        return Arrays.stream(repositoryElement.stringValues(RepositoryConfiguration.class, "queryDtoTypes")).anyMatch(type -> classElement.getName().equals(type));
    }

    private List<SourcePersistentProperty> getDtoProjectionProperties(SourcePersistentEntity entity, ClassElement returnType) {
        return returnType.getBeanProperties().stream().filter(dtoProperty -> {
            String propertyName = dtoProperty.getName();
            return !"metaClass".equals(propertyName) || !dtoProperty.getType().isAssignable("groovy.lang.MetaClass");
        }).map(dtoProperty -> {
            String propertyName = dtoProperty.getName();
            if ("metaClass".equals(propertyName) && dtoProperty.getType().isAssignable("groovy.lang.MetaClass")) {
                return null;
            }
            SourcePersistentProperty pp = entity.getPropertyByName(propertyName);
            if (pp == null) {
                pp = entity.getIdOrVersionPropertyByName(propertyName);
            }
            if (pp == null) {
                throw new MatchFailedException("Property " + propertyName + " is not present in entity: " + entity.getName());
            }
            ClassElement dtoPropertyType = dtoProperty.getType();
            if (dtoPropertyType.getName().equals("java.lang.Object") || dtoPropertyType.getName().equals("java.lang.String")) {
                return pp;
            }
            if (!TypeUtils.areTypesCompatible(dtoPropertyType, pp.getType())) {
                throw new MatchFailedException("Property [" + propertyName + "] of type [" + dtoPropertyType.getName() + "] is not compatible with equivalent property of type [" + pp.getType().getName() + "] declared in entity: " + entity.getName());
            }
            return pp;
        }).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void applyProjectionLimits(String querySequence, MatchContext matchContext, PersistentEntityCriteriaQuery<T> query) {
        if (StringUtils.isEmpty((CharSequence)querySequence)) {
            return;
        }
        String decapitalized = NameUtils.decapitalize((String)querySequence);
        if (Arrays.asList("all", "one").contains(decapitalized)) return;
        Matcher topMatcher = Pattern.compile("^(top|first)(\\d*)$").matcher(decapitalized);
        if (topMatcher.find()) {
            String str = topMatcher.group(2);
            try {
                int max;
                int n = max = StringUtils.isNotEmpty((CharSequence)str) ? Integer.parseInt(str) : 1;
                if (max <= -1) return;
                query.max(max);
                return;
            }
            catch (NumberFormatException e) {
                throw new MatchFailedException("Invalid number specified to top: " + str);
            }
        } else {
            if (querySequence.equals(matchContext.getReturnType().getSimpleName())) return;
            throw new MatchFailedException("Cannot project on non-existent property: " + decapitalized);
        }
    }

    private <T> String applyOrderBy(String querySequence, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, PersistentEntityCriteriaBuilder cb) {
        if (ORDER_BY_PATTERN.matcher(querySequence).matches()) {
            ArrayList<Order> orders = new ArrayList<Order>();
            Matcher matcher = ORDER_BY_PATTERN.matcher(querySequence);
            StringBuffer buffer = new StringBuffer();
            if (matcher.find()) {
                matcher.appendReplacement(buffer, "$1");
                String orderDefGroup = matcher.group(3);
                if (StringUtils.isNotEmpty((CharSequence)orderDefGroup)) {
                    String[] orderDefItems;
                    for (String orderDef : orderDefItems = orderDefGroup.split("And")) {
                        String propertyName;
                        String prop = NameUtils.decapitalize((String)orderDef);
                        if (prop.endsWith("Desc")) {
                            propertyName = prop.substring(0, prop.length() - 4);
                            orders.add(cb.desc(this.findOrderProperty(root, propertyName)));
                            continue;
                        }
                        if (prop.endsWith("Asc")) {
                            propertyName = prop.substring(0, prop.length() - 3);
                            orders.add(cb.asc(this.findOrderProperty(root, propertyName)));
                            continue;
                        }
                        orders.add(cb.asc(this.findOrderProperty(root, prop)));
                    }
                }
            }
            if (!orders.isEmpty()) {
                query.orderBy(orders);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        return querySequence;
    }

    private <T> PersistentPropertyPath<?> findOrderProperty(PersistentEntityRoot<T> root, String propertyName) {
        if (root.getPersistentEntity().getPropertyByName(propertyName) != null) {
            return root.get(propertyName);
        }
        PersistentPropertyPath<Object> property = this.findProperty(root, propertyName);
        if (property != null) {
            return property;
        }
        throw new MatchFailedException("Cannot order by non-existent property: " + propertyName);
    }

    protected <T> String applyProjections(String querySequence, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, PersistentEntityCriteriaBuilder cb) {
        if (querySequence.startsWith("Distinct")) {
            query.distinct(true);
            querySequence = querySequence.substring("Distinct".length());
        }
        if (StringUtils.isNotEmpty((CharSequence)querySequence)) {
            ArrayList<Object> selectionList = new ArrayList<Object>();
            for (String projection : querySequence.split("And")) {
                PersistentPropertyPath<Object> propertyPath = this.findProperty(root, projection);
                if (propertyPath != null) {
                    selectionList.add(propertyPath);
                    continue;
                }
                Selection<?> selection = Projections.find(root, cb, projection, (x$0, x$1) -> this.findProperty(x$0, (String)x$1));
                if (selection == null) continue;
                selectionList.add(selection);
            }
            if (selectionList.isEmpty()) {
                return querySequence;
            }
            query.multiselect(selectionList);
            return "";
        }
        return querySequence;
    }

    @Override
    protected DataMethod.OperationType getOperationType() {
        return DataMethod.OperationType.QUERY;
    }
}

