/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.FindByIdInterceptor;
import io.micronaut.data.intercept.FindOneInterceptor;
import io.micronaut.data.intercept.async.FindByIdAsyncInterceptor;
import io.micronaut.data.intercept.async.FindOneAsyncInterceptor;
import io.micronaut.data.intercept.reactive.FindByIdReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindOneReactiveInterceptor;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternMethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.criteria.QueryCriteriaMethodMatch;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;

@Internal
public final class FindMethodMatcher
extends AbstractPatternMethodMatcher {
    public FindMethodMatcher() {
        super(true, "find", "get", "query", "retrieve", "read", "search");
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        if (this.isCompatibleReturnType(matchContext)) {
            return new QueryCriteriaMethodMatch(matcher){
                boolean hasIdMatch;

                @Override
                protected <T> void apply(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                    super.apply(matchContext, root, query, cb);
                    if (query instanceof AbstractPersistentEntityCriteriaQuery) {
                        this.hasIdMatch = ((AbstractPersistentEntityCriteriaQuery)query).hasOnlyIdRestriction();
                    }
                }

                @Override
                protected Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
                    Map.Entry<ClassElement, Class<? extends DataInterceptor>> e = super.resolveReturnTypeAndInterceptor(matchContext);
                    Class<? extends DataInterceptor> interceptorType = e.getValue();
                    ClassElement queryResultType = e.getKey();
                    if (this.isFindByIdQuery(matchContext, queryResultType)) {
                        if (interceptorType == FindOneInterceptor.class) {
                            interceptorType = FindByIdInterceptor.class;
                        } else if (interceptorType == FindOneAsyncInterceptor.class) {
                            interceptorType = FindByIdAsyncInterceptor.class;
                        } else if (interceptorType == FindOneReactiveInterceptor.class) {
                            interceptorType = FindByIdReactiveInterceptor.class;
                        }
                    }
                    return new AbstractMap.SimpleEntry<ClassElement, Class<? extends DataInterceptor>>(queryResultType, interceptorType);
                }

                private boolean isFindByIdQuery(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType) {
                    return this.hasIdMatch && matchContext.supportsImplicitQueries() && queryResultType.getName().equals(matchContext.getRootEntity().getName()) && this.hasNoWhereAndJoinDeclaration(matchContext);
                }
            };
        }
        return null;
    }

    private boolean isCompatibleReturnType(@NonNull MatchContext matchContext) {
        MethodElement methodElement = matchContext.getMethodElement();
        ClassElement returnType = TypeUtils.getMethodProducingItemType(methodElement);
        if (returnType == null) {
            return false;
        }
        if (Arrays.stream(matchContext.getRepositoryClass().stringValues(RepositoryConfiguration.class, "queryReturnTypes")).anyMatch(type -> returnType.getName().equals(type))) {
            return true;
        }
        if (!TypeUtils.isVoid(returnType)) {
            return returnType.hasStereotype(Introspected.class) || returnType.isPrimitive() || ClassUtils.isJavaBasicType((String)returnType.getName()) || TypeUtils.isContainerType(returnType);
        }
        ClassElement genericReturnType = methodElement.getGenericReturnType();
        return matchContext.isTypeInRole(genericReturnType, "page") || matchContext.isTypeInRole(genericReturnType, "slice");
    }
}

