/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.criteria.QueryCriteriaMethodMatch;
import io.micronaut.inject.ast.ClassElement;
import jakarta.persistence.criteria.Selection;
import java.util.Map;
import java.util.regex.Matcher;

@Internal
public final class ExistsMethodMatcher
extends AbstractPatternMethodMatcher {
    public ExistsMethodMatcher() {
        super(false, "exists");
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        if (TypeUtils.doesMethodProducesABoolean(matchContext.getMethodElement())) {
            return new QueryCriteriaMethodMatch(matcher){

                @Override
                protected <T> String applyProjections(String querySequence, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, PersistentEntityCriteriaBuilder cb) {
                    query.multiselect(new Selection[]{cb.literal((Object)true)});
                    return "";
                }

                @Override
                protected Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
                    return FindersUtils.pickExistsInterceptor(matchContext, matchContext.getReturnType());
                }

                @Override
                protected DataMethod.OperationType getOperationType() {
                    return DataMethod.OperationType.EXISTS;
                }
            };
        }
        return null;
    }
}

