/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.criteria;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaUpdate;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.model.criteria.impl.MethodMatchSourcePersistentEntityCriteriaBuilderImpl;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractCriteriaMethodMatch;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Map;
import java.util.regex.Matcher;

public class UpdateCriteriaMethodMatch
extends AbstractCriteriaMethodMatch {
    public UpdateCriteriaMethodMatch(Matcher matcher) {
        super(matcher);
    }

    protected <T> void apply(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
        String querySequence = this.matcher.group(3);
        if (this.matcher.group(2).endsWith("By")) {
            this.applyPredicates(querySequence, matchContext.getParameters(), root, query, cb);
        } else {
            this.applyPredicates(matchContext.getParametersNotInRole(), root, query, cb);
        }
        if (query.getRestriction() == null) {
            throw new MatchFailedException("Cannot implement batch update operation that doesn't perform a query");
        }
        SourcePersistentEntity entity = matchContext.getRootEntity();
        this.addPropertiesToUpdate(matchContext, root, query, cb);
        entity.getPersistentProperties().stream().filter(p -> p != null && p.findAnnotation(AutoPopulated.class).map(ap -> (Boolean)ap.getRequiredValue("updateable", Boolean.class)).orElse(false) != false).forEach(p -> query.set(p.getName(), cb.parameter(null)));
        if (entity.getVersion() != null && ((AbstractPersistentEntityCriteriaUpdate)query).hasVersionRestriction()) {
            query.set(entity.getVersion().getName(), cb.parameter(null));
        }
        if (((AbstractPersistentEntityCriteriaUpdate)query).getUpdateValues().isEmpty()) {
            throw new MatchFailedException("At least one parameter required to update");
        }
    }

    protected <T> void addPropertiesToUpdate(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
    }

    @Override
    protected MethodMatchInfo build(MethodMatchContext matchContext) {
        MethodMatchSourcePersistentEntityCriteriaBuilderImpl cb = new MethodMatchSourcePersistentEntityCriteriaBuilderImpl(matchContext);
        PersistentEntityCriteriaUpdate criteriaQuery = cb.createCriteriaUpdate((Class)null);
        this.apply(matchContext, criteriaQuery.from((PersistentEntity)matchContext.getRootEntity()), criteriaQuery, cb);
        Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = this.resolveReturnTypeAndInterceptor(matchContext);
        ClassElement resultType = entry.getKey();
        Class<? extends DataInterceptor> interceptorType = entry.getValue();
        AbstractPersistentEntityCriteriaUpdate criteriaUpdate = (AbstractPersistentEntityCriteriaUpdate)criteriaQuery;
        boolean optimisticLock = criteriaUpdate.hasVersionRestriction();
        AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass().getAnnotationMetadata(), matchContext.getAnnotationMetadata()});
        QueryBuilder queryBuilder = matchContext.getQueryBuilder();
        Map propertiesToUpdate = criteriaUpdate.getUpdateValues();
        QueryModel queryModel = ((AbstractPersistentEntityCriteriaUpdate)criteriaQuery).getQueryModel();
        QueryResult queryResult = queryBuilder.buildUpdate((AnnotationMetadata)annotationMetadataHierarchy, queryModel, propertiesToUpdate);
        return new MethodMatchInfo(DataMethod.OperationType.UPDATE, (TypedElement)resultType, this.getInterceptorElement(matchContext, interceptorType)).optimisticLock(optimisticLock).queryResult(queryResult);
    }

    @Override
    protected DataMethod.OperationType getOperationType() {
        return DataMethod.OperationType.UPDATE;
    }
}

