/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.event.EntityEventMapping;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import javax.inject.Scope;

public class EntityEventVisitor
implements TypeElementVisitor<Object, EntityEventMapping> {
    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        String eventMapping = element.getAnnotationNameByStereotype(EntityEventMapping.class).orElse(null);
        if (eventMapping != null) {
            if (element.isPrivate() || element.isStatic()) {
                context.fail("Method annotated with @" + NameUtils.getSimpleName((String)eventMapping) + " must be a non-private instance method", (Element)element);
            }
            if (element.hasStereotype(MappedEntity.class)) {
                if (!element.getReturnType().getName().equals("void") || element.getParameters().length != 0) {
                    context.fail("Method annotated with @" + NameUtils.getSimpleName((String)eventMapping) + " must return void and declare no arguments", (Element)element);
                }
            } else if (element.hasStereotype(Scope.class) && (!element.getReturnType().getName().equals("void") || element.getParameters().length != 1)) {
                context.fail("Method annotated with @" + NameUtils.getSimpleName((String)eventMapping) + " must return void and declare exactly one argument that represents the entity type to listen for", (Element)element);
            }
        }
    }
}

