/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractListMethod;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;

public class ListMethod
extends AbstractListMethod {
    public static final String[] PREFIXES = new String[]{"list", "find", "search", "query"};

    public ListMethod() {
        super(PREFIXES);
    }

    @Override
    public int getOrder() {
        return 100;
    }

    @Override
    public boolean isMethodMatch(@NonNull MethodElement methodElement, @NonNull MatchContext matchContext) {
        return (super.isMethodMatch(methodElement, matchContext) || methodElement.hasAnnotation(Query.class)) && this.isValidReturnType(matchContext.getReturnType(), matchContext);
    }

    protected boolean isValidReturnType(@NonNull ClassElement returnType, MatchContext matchContext) {
        return TypeUtils.isContainerType(returnType);
    }
}

