/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.value.OptionalValues;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public final class AnnotationMetadataHierarchy
implements AnnotationMetadata {
    private final AnnotationMetadata[] hierarchy;

    public AnnotationMetadataHierarchy(AnnotationMetadata ... hierarchy) {
        if (ArrayUtils.isNotEmpty((Object[])hierarchy)) {
            List<AnnotationMetadata> list = Arrays.asList(hierarchy);
            Collections.reverse(list);
            this.hierarchy = list.toArray(new AnnotationMetadata[0]);
        } else {
            this.hierarchy = new AnnotationMetadata[]{AnnotationMetadata.EMPTY_METADATA};
        }
    }

    @Nonnull
    public OptionalDouble doubleValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o = annotationMetadata.doubleValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    @Nonnull
    public String[] stringValues(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return (String[])Arrays.stream(this.hierarchy).flatMap(am -> Stream.of(am.stringValues(annotation, member))).toArray(String[]::new);
    }

    public Optional<Boolean> booleanValue(@Nonnull String annotation, @Nonnull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.booleanValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    public boolean isTrue(@Nonnull String annotation, @Nonnull String member) {
        return Arrays.stream(this.hierarchy).anyMatch(am -> am.isTrue(annotation, member));
    }

    public OptionalLong longValue(@Nonnull String annotation, @Nonnull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalLong o = annotationMetadata.longValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalLong.empty();
    }

    public Optional<String> stringValue(@Nonnull String annotation, @Nonnull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.stringValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    public OptionalInt intValue(@Nonnull String annotation, @Nonnull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalInt o = annotationMetadata.intValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalInt.empty();
    }

    @Nonnull
    public OptionalDouble doubleValue(@Nonnull String annotation, @Nonnull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalDouble o = annotationMetadata.doubleValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return OptionalDouble.empty();
    }

    public <E extends Enum> Optional<E> enumValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, Class<E> enumType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.enumValue(annotation, member, enumType);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Nonnull
    public <T> Class<T>[] classValues(@Nonnull String annotation, @Nonnull String member) {
        Class[] classes = (Class[])Arrays.stream(this.hierarchy).flatMap(am -> Stream.of(am.classValues(annotation, member))).toArray(Class[]::new);
        return classes;
    }

    public Optional<Class> classValue(@Nonnull String annotation, @Nonnull String member) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional o = annotationMetadata.classValue(annotation, member);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    @Nonnull
    public List<String> getAnnotationNamesByStereotype(@Nullable String stereotype) {
        return Arrays.stream(this.hierarchy).flatMap(am -> am.getDeclaredAnnotationNamesByStereotype(stereotype).stream()).collect(Collectors.toList());
    }

    @Nonnull
    public Set<String> getDeclaredAnnotationNames() {
        return this.hierarchy[0].getDeclaredAnnotationNames();
    }

    @Nonnull
    public Set<String> getAnnotationNames() {
        return Arrays.stream(this.hierarchy).flatMap(am -> am.getDeclaredAnnotationNames().stream()).collect(Collectors.toSet());
    }

    @Nonnull
    public <T> OptionalValues<T> getValues(@Nonnull String annotation, @Nonnull Class<T> valueType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            OptionalValues values = annotationMetadata.getValues(annotation, valueType);
            if (values.isEmpty()) continue;
            return values;
        }
        return OptionalValues.empty();
    }

    public <T> Optional<T> getDefaultValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Argument<T> requiredType) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Optional defaultValue = annotationMetadata.getDefaultValue(annotation, member, requiredType);
            if (!defaultValue.isPresent()) continue;
            return defaultValue;
        }
        return Optional.empty();
    }

    @Nonnull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@Nonnull Class<T> annotationType) {
        return Arrays.stream(this.hierarchy).flatMap(am -> am.getDeclaredAnnotationValuesByType(annotationType).stream()).collect(Collectors.toList());
    }

    @Nonnull
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@Nonnull Class<T> annotationType) {
        return this.hierarchy[0].getDeclaredAnnotationValuesByType(annotationType);
    }

    public boolean hasDeclaredAnnotation(@Nullable String annotation) {
        return this.hierarchy[0].hasDeclaredAnnotation(annotation);
    }

    public boolean hasAnnotation(@Nullable String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.hasDeclaredAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStereotype(@Nullable String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            if (!annotationMetadata.hasDeclaredStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeclaredStereotype(@Nullable String annotation) {
        return this.hierarchy[0].hasDeclaredStereotype(annotation);
    }

    @Nonnull
    public Map<String, Object> getDefaultValues(@Nonnull String annotation) {
        for (AnnotationMetadata annotationMetadata : this.hierarchy) {
            Map defaultValues = annotationMetadata.getDefaultValues(annotation);
            if (defaultValues.isEmpty()) continue;
            return defaultValues;
        }
        return Collections.emptyMap();
    }
}

