/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.DeleteMethod;
import io.micronaut.data.processor.visitors.finders.DynamicFinder;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;

public class DeleteByMethod
extends DynamicFinder {
    protected static final String[] PREFIXES = new String[]{"delete", "remove", "erase", "eliminate"};

    public DeleteByMethod() {
        super(PREFIXES);
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        return super.isMethodMatch(methodElement, matchContext) && TypeUtils.isValidBatchUpdateReturnType(methodElement);
    }

    @Override
    @Nullable
    protected MethodMatchInfo buildInfo(MethodMatchContext matchContext, ClassElement queryResultType, @Nullable QueryModel query) {
        if (query == null) {
            matchContext.fail("Unable to implement delete method with no query arguments");
            return null;
        }
        return new MethodMatchInfo(null, query, DeleteMethod.pickDeleteAllInterceptor(matchContext.getReturnType()), MethodMatchInfo.OperationType.DELETE, new String[0]);
    }
}

