/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.transaction;

import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.SynchronousConnectionManager;
import io.micronaut.data.mongodb.conf.RequiresSyncMongo;
import io.micronaut.data.mongodb.transaction.MongoTransactionOperations;
import io.micronaut.transaction.exceptions.NoTransactionException;
import io.micronaut.transaction.impl.DefaultTransactionStatus;
import io.micronaut.transaction.support.AbstractDefaultTransactionOperations;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
@RequiresSyncMongo
@EachBean(value=MongoClient.class)
final class MongoTransactionOperationsImpl
extends AbstractDefaultTransactionOperations<ClientSession>
implements MongoTransactionOperations {
    MongoTransactionOperationsImpl(@Parameter ConnectionOperations<ClientSession> connectionOperations, @Parameter @Nullable SynchronousConnectionManager<ClientSession> synchronousConnectionManager) {
        super(connectionOperations, synchronousConnectionManager);
    }

    public @NonNull ClientSession getConnection() {
        return (ClientSession)this.connectionOperations.findConnectionStatus().flatMap(status -> ((ClientSession)status.getConnection()).hasActiveTransaction() ? Optional.of((ClientSession)status.getConnection()) : Optional.empty()).orElseThrow(() -> new NoTransactionException("No active MongoDB client session!"));
    }

    protected void doBegin(DefaultTransactionStatus<ClientSession> tx) {
        TransactionOptions.Builder txOptionsBuilder = TransactionOptions.builder();
        this.determineTimeout(tx.getTransactionDefinition()).ifPresent(timeout -> txOptionsBuilder.maxCommitTime(Long.valueOf(timeout.toMillis()), TimeUnit.MILLISECONDS));
        ((ClientSession)tx.getConnection()).startTransaction(txOptionsBuilder.build());
    }

    protected void doCommit(DefaultTransactionStatus<ClientSession> tx) {
        ((ClientSession)tx.getConnection()).commitTransaction();
    }

    protected void doRollback(DefaultTransactionStatus<ClientSession> tx) {
        ((ClientSession)tx.getConnection()).abortTransaction();
    }
}

