/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.session;

import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoClient;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.support.AbstractReactorConnectionOperations;
import io.micronaut.data.mongodb.conf.RequiresReactiveMongo;
import io.micronaut.data.mongodb.session.MongoReactorConnectionOperations;
import org.jspecify.annotations.NonNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@RequiresReactiveMongo
@EachBean(value=MongoClient.class)
@Internal
final class DefaultMongoReactorConnectionOperations
extends AbstractReactorConnectionOperations<ClientSession>
implements MongoReactorConnectionOperations {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMongoReactorConnectionOperations.class);
    private final String serverName;
    private final MongoClient mongoClient;

    DefaultMongoReactorConnectionOperations(@Parameter String serverName, MongoClient mongoClient) {
        this.mongoClient = mongoClient;
        this.serverName = serverName;
    }

    protected @NonNull Publisher<ClientSession> openConnection(@NonNull ConnectionDefinition definition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening Connection for MongoDB configuration: {} and definition: {}", (Object)this.serverName, (Object)definition);
        }
        return this.mongoClient.startSession();
    }

    protected @NonNull Publisher<Void> closeConnection(@NonNull ClientSession connection, @NonNull ConnectionDefinition definition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing Connection for MongoDB configuration: {} and definition: {}", (Object)this.serverName, (Object)definition);
        }
        connection.close();
        return Mono.empty();
    }
}

