/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.database;

import com.mongodb.ConnectionString;
import io.micronaut.configuration.mongo.core.DefaultMongoConfiguration;
import io.micronaut.configuration.mongo.core.NamedMongoConfiguration;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.mongodb.operations.DefaultMongoDatabaseNameProvider;
import io.micronaut.data.mongodb.operations.MongoDatabaseNameProvider;
import io.micronaut.data.runtime.multitenancy.SchemaTenantResolver;
import jakarta.inject.Singleton;
import org.jspecify.annotations.Nullable;

@Internal
@Factory
final class MongoDatabaseNameProviderFactory {
    MongoDatabaseNameProviderFactory() {
    }

    @Primary
    @Singleton
    MongoDatabaseNameProvider primaryMongoDatabaseNameProvider(DefaultMongoConfiguration mongoConfiguration, BeanContext beanContext, RuntimeEntityRegistry runtimeEntityRegistry, @Nullable SchemaTenantResolver tenantResolver) {
        String defaultDatabaseName = mongoConfiguration.getConnectionString().map(ConnectionString::getDatabase).filter(StringUtils::isNotEmpty).orElse(null);
        return new DefaultMongoDatabaseNameProvider(beanContext, null, runtimeEntityRegistry, defaultDatabaseName, tenantResolver);
    }

    @EachBean(value=NamedMongoConfiguration.class)
    @Singleton
    MongoDatabaseNameProvider namedMongoDatabaseNameProvider(NamedMongoConfiguration mongoConfiguration, @Parameter String server, BeanContext beanContext, RuntimeEntityRegistry runtimeEntityRegistry, @Nullable SchemaTenantResolver tenantResolver) {
        String defaultDatabaseName = mongoConfiguration.getConnectionString().map(ConnectionString::getDatabase).filter(StringUtils::isNotEmpty).orElse(null);
        return new DefaultMongoDatabaseNameProvider(beanContext, server, runtimeEntityRegistry, defaultDatabaseName, tenantResolver);
    }
}

