/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.ReplaceOptions;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.mongodb.operations.DefaultMongoPreparedQuery;
import io.micronaut.data.mongodb.operations.DefaultMongoStoredQuery;
import io.micronaut.data.mongodb.operations.MongoAggregation;
import io.micronaut.data.mongodb.operations.MongoCollectionNameProvider;
import io.micronaut.data.mongodb.operations.MongoDatabaseNameProvider;
import io.micronaut.data.mongodb.operations.MongoFind;
import io.micronaut.data.mongodb.operations.MongoPreparedQuery;
import io.micronaut.data.mongodb.operations.MongoStoredQuery;
import io.micronaut.data.mongodb.operations.MongoUtils;
import io.micronaut.data.mongodb.operations.options.MongoAggregationOptions;
import io.micronaut.data.mongodb.operations.options.MongoFindOptions;
import io.micronaut.data.mongodb.operations.options.MongoOptionsUtils;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.BeanIntrospectionMapper;
import io.micronaut.data.runtime.operations.internal.AbstractRepositoryOperations;
import io.micronaut.data.runtime.query.MethodContextAwareStoredQueryDecorator;
import io.micronaut.data.runtime.query.PreparedQueryDecorator;
import io.micronaut.data.runtime.query.internal.QueryResultStoredQuery;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.slf4j.Logger;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
abstract class AbstractMongoRepositoryOperations<Dtb>
extends AbstractRepositoryOperations
implements HintsCapableRepository,
PreparedQueryDecorator,
MethodContextAwareStoredQueryDecorator {
    protected static final BsonDocument EMPTY = new BsonDocument();
    protected static final Logger QUERY_LOG = DataSettings.QUERY_LOG;
    protected final MongoCollectionNameProvider collectionNameProvider;
    protected final MongoDatabaseNameProvider databaseNameProvider;

    protected AbstractMongoRepositoryOperations(DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService conversionService, AttributeConverterRegistry attributeConverterRegistry, MongoCollectionNameProvider collectionNameProvider, MongoDatabaseNameProvider databaseNameProvider) {
        super(dateTimeProvider, runtimeEntityRegistry, conversionService, attributeConverterRegistry);
        this.collectionNameProvider = collectionNameProvider;
        this.databaseNameProvider = databaseNameProvider;
    }

    protected final ReplaceOptions getReplaceOptions(AnnotationMetadata annotationMetadata) {
        return MongoOptionsUtils.buildReplaceOptions(annotationMetadata).orElseGet(ReplaceOptions::new);
    }

    protected final InsertOneOptions getInsertOneOptions(AnnotationMetadata annotationMetadata) {
        return MongoOptionsUtils.buildInsertOneOptions(annotationMetadata).orElseGet(InsertOneOptions::new);
    }

    protected final InsertManyOptions getInsertManyOptions(AnnotationMetadata annotationMetadata) {
        return MongoOptionsUtils.buildInsertManyOptions(annotationMetadata).orElseGet(InsertManyOptions::new);
    }

    protected final DeleteOptions getDeleteOptions(AnnotationMetadata annotationMetadata) {
        return MongoOptionsUtils.buildDeleteOptions(annotationMetadata, true).orElseGet(DeleteOptions::new);
    }

    protected abstract Dtb getDatabase(PersistentEntity var1, Class<?> var2);

    protected abstract CodecRegistry getCodecRegistry(Dtb var1);

    protected <E, R> MongoStoredQuery<E, R> getMongoStoredQuery(StoredQuery<E, R> storedQuery) {
        if (storedQuery instanceof MongoStoredQuery) {
            return (MongoStoredQuery)storedQuery;
        }
        throw new IllegalStateException("Expected for stored query to be of type: MongoStoredQuery");
    }

    protected <E, R> MongoPreparedQuery<E, R> getMongoPreparedQuery(PreparedQuery<E, R> preparedQuery) {
        if (preparedQuery instanceof MongoPreparedQuery) {
            return (MongoPreparedQuery)preparedQuery;
        }
        throw new IllegalStateException("Expected for prepared query to be of type: MongoPreparedQuery");
    }

    public <E, R> PreparedQuery<E, R> decorate(PreparedQuery<E, R> preparedQuery) {
        return new DefaultMongoPreparedQuery<E, R>(preparedQuery);
    }

    public <E, R> StoredQuery<E, R> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, R> storedQuery) {
        QueryResultStoredQuery resultStoredQuery;
        String update;
        RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(storedQuery.getRootEntity());
        Class<?> repositoryType = context.getTarget().getClass();
        Supplier codecRegistry = SupplierUtil.memoizedNonEmpty(() -> this.getCodecRegistry(this.getDatabase((PersistentEntity)persistentEntity, repositoryType)));
        if (storedQuery instanceof QueryResultStoredQuery && (update = (resultStoredQuery = (QueryResultStoredQuery)storedQuery).getQueryResult().getUpdate()) != null) {
            return new DefaultMongoStoredQuery<E, R>(storedQuery, codecRegistry, this.attributeConverterRegistry, this.runtimeEntityRegistry, (ConversionService)this.conversionService, persistentEntity, update);
        }
        return new DefaultMongoStoredQuery<E, R>(storedQuery, codecRegistry, this.attributeConverterRegistry, this.runtimeEntityRegistry, (ConversionService)this.conversionService, persistentEntity);
    }

    protected <R> R convertResult(CodecRegistry codecRegistry, Class<R> resultType, BsonDocument result, boolean isDtoProjection) {
        BsonNull value;
        if (resultType == BsonDocument.class) {
            return (R)result;
        }
        Optional introspection = BeanIntrospector.SHARED.findIntrospection(resultType);
        if (introspection.isPresent()) {
            return (R)new BeanIntrospectionMapper<BsonDocument, R>(){

                public Object read(BsonDocument document, String alias) {
                    BsonValue bsonValue = document.get((Object)alias);
                    if (bsonValue == null) {
                        return null;
                    }
                    return MongoUtils.toValue(bsonValue);
                }

                public ConversionService getConversionService() {
                    return AbstractMongoRepositoryOperations.this.conversionService;
                }
            }.map((Object)result, resultType);
        }
        if (result == null) {
            value = BsonNull.VALUE;
        } else if (result.size() == 1) {
            value = (BsonValue)result.values().iterator().next();
        } else if (result.size() == 2) {
            Optional<Map.Entry> id = result.entrySet().stream().filter(f -> !((String)f.getKey()).equals("_id")).findFirst();
            value = id.isPresent() ? (BsonValue)id.get().getValue() : (BsonValue)result.values().iterator().next();
        } else {
            if (isDtoProjection) {
                R dtoResult = MongoUtils.toValue(result.asDocument(), resultType, codecRegistry);
                if (resultType.isInstance(dtoResult)) {
                    return dtoResult;
                }
                return (R)this.conversionService.convertRequired(dtoResult, resultType);
            }
            throw new IllegalStateException("Unrecognized result: " + result);
        }
        return (R)this.conversionService.convertRequired(MongoUtils.toValue((BsonValue)value), resultType);
    }

    protected BsonDocument association(CodecRegistry codecRegistry, Object value, RuntimePersistentEntity<Object> persistentEntity, Object child, RuntimePersistentEntity<Object> childPersistentEntity) {
        BsonDocument document = new BsonDocument();
        document.put(persistentEntity.getPersistedName(), MongoUtils.entityIdValue((ConversionService)this.conversionService, persistentEntity, value, codecRegistry));
        document.put(childPersistentEntity.getPersistedName(), MongoUtils.entityIdValue((ConversionService)this.conversionService, childPersistentEntity, child, codecRegistry));
        return document;
    }

    protected final <T> Bson createFilterIdAndVersion(RuntimePersistentEntity<T> persistentEntity, T entity, CodecRegistry codecRegistry) {
        BsonDocument bsonDocument = BsonDocumentWrapper.asBsonDocument(entity, (CodecRegistry)codecRegistry);
        BsonDocument filter = new BsonDocument();
        filter.put("_id", bsonDocument.get((Object)"_id"));
        RuntimePersistentProperty version = persistentEntity.getVersion();
        if (version != null) {
            filter.put(version.getPersistedName(), bsonDocument.get((Object)version.getPersistedName()));
        }
        return filter;
    }

    protected void logFind(MongoFind find) {
        StringBuilder sb = new StringBuilder("Executing Mongo 'find'");
        MongoFindOptions options = find.getOptions();
        if (options != null) {
            Collation collation;
            Bson projection;
            sb.append(" with");
            Bson filter = options.getFilter();
            sb.append(" filter: ").append(filter == null ? "{}" : filter.toBsonDocument().toJson());
            Bson sort = options.getSort();
            if (sort != null) {
                sb.append(" sort: ").append(sort.toBsonDocument().toJson());
            }
            if ((projection = options.getProjection()) != null) {
                sb.append(" projection: ").append(projection.toBsonDocument().toJson());
            }
            if ((collation = options.getCollation()) != null) {
                sb.append(" collation: ").append(collation);
            }
        }
        QUERY_LOG.debug(sb.toString());
    }

    protected void logAggregate(MongoAggregation aggregation) {
        MongoAggregationOptions options = aggregation.getOptions();
        StringBuilder sb = new StringBuilder("Executing Mongo 'aggregate'");
        if (options != null) {
            sb.append(" with");
            sb.append(" pipeline: ").append(aggregation.getPipeline().stream().map(e -> e.toBsonDocument().toJson()).collect(Collectors.toList()));
            Collation collation = options.getCollation();
            if (collation != null) {
                sb.append(" collation: ").append(collation);
            }
        }
        QUERY_LOG.debug(sb.toString());
    }
}

