/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.init;

import io.micronaut.configuration.mongo.core.AbstractMongoConfiguration;
import io.micronaut.configuration.mongo.core.DefaultMongoConfiguration;
import io.micronaut.configuration.mongo.core.NamedMongoConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Context;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Context
@Internal
public class AbstractMongoCollectionsCreator<Dtbs> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMongoCollectionsCreator.class);

    protected <M> M getMongoFactory(Class<M> mongoFactoryClass, BeanLocator beanLocator, AbstractMongoConfiguration mongoConfiguration) {
        if (mongoConfiguration instanceof DefaultMongoConfiguration) {
            return (M)beanLocator.getBean(mongoFactoryClass);
        }
        if (mongoConfiguration instanceof NamedMongoConfiguration) {
            NamedMongoConfiguration namedMongoConfiguration = (NamedMongoConfiguration)mongoConfiguration;
            Qualifier qualifier = Qualifiers.byName((String)namedMongoConfiguration.getServerName());
            return (M)beanLocator.getBean(mongoFactoryClass, qualifier);
        }
        throw new IllegalStateException("Cannot get MongoDB client for unrecognized configuration: " + String.valueOf(mongoConfiguration));
    }

    protected void initialize(RuntimeEntityRegistry runtimeEntityRegistry, List<AbstractMongoConfiguration> mongoConfigurations, DatabaseOperationsProvider<Dtbs> databaseOperationsProvider) {
        for (AbstractMongoConfiguration mongoConfiguration : mongoConfigurations) {
            Collection introspections = BeanIntrospector.SHARED.findIntrospections(MappedEntity.class);
            PersistentEntity[] entities = (PersistentEntity[])introspections.stream().filter(i -> !i.getBeanType().getName().contains("$")).filter(i -> !Modifier.isAbstract(i.getBeanType().getModifiers())).map(e -> runtimeEntityRegistry.getEntity(e.getBeanType())).toArray(PersistentEntity[]::new);
            DatabaseOperations<Dtbs> databaseOperations = databaseOperationsProvider.get(mongoConfiguration);
            for (PersistentEntity entity : entities) {
                String persistedName;
                Dtbs database = databaseOperations.find(entity);
                Set<String> collections = databaseOperations.listCollectionNames(database);
                if (collections.add(persistedName = entity.getPersistedName())) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Creating collection: {} in database: {}", (Object)persistedName, (Object)databaseOperations.getDatabaseName(database));
                    }
                    databaseOperations.createCollection(database, persistedName);
                }
                for (PersistentProperty persistentProperty : entity.getPersistentProperties()) {
                    if (!(persistentProperty instanceof Association)) continue;
                    Association association = (Association)persistentProperty;
                    Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
                    if (association.getKind() != Relation.Kind.MANY_TO_MANY && (!association.isForeignKey() || inverseSide.isPresent())) continue;
                    Association owningAssociation = inverseSide.orElse(association);
                    NamingStrategy namingStrategy = association.getOwner().getNamingStrategy();
                    String joinCollectionName = namingStrategy.mappedName(owningAssociation);
                    if (!collections.add(joinCollectionName)) continue;
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Creating collection: {} in database: {}", (Object)persistedName, (Object)databaseOperations.getDatabaseName(database));
                    }
                    databaseOperations.createCollection(database, joinCollectionName);
                }
            }
        }
    }

    static interface DatabaseOperationsProvider<Dtbs> {
        public DatabaseOperations<Dtbs> get(AbstractMongoConfiguration var1);
    }

    static interface DatabaseOperations<Dtbs> {
        public String getDatabaseName(Dtbs var1);

        public Dtbs find(PersistentEntity var1);

        public Set<String> listCollectionNames(Dtbs var1);

        public void createCollection(Dtbs var1, String var2);
    }
}

