/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations.options;

import com.mongodb.client.model.Collation;
import io.micronaut.core.annotation.Nullable;
import org.bson.conversions.Bson;

public final class MongoAggregationOptions {
    private Boolean allowDiskUse;
    private Long maxTimeMS;
    private Long maxAwaitTimeMS;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private String comment;
    private Bson hint;

    public MongoAggregationOptions() {
    }

    public MongoAggregationOptions(MongoAggregationOptions options) {
        this.allowDiskUse = options.allowDiskUse;
        this.maxTimeMS = options.maxTimeMS;
        this.maxAwaitTimeMS = options.maxAwaitTimeMS;
        this.bypassDocumentValidation = options.bypassDocumentValidation;
        this.collation = options.collation;
        this.comment = options.comment;
        this.hint = options.hint;
    }

    public void copyNotNullFrom(MongoAggregationOptions options) {
        if (options.allowDiskUse != null) {
            this.allowDiskUse = options.allowDiskUse;
        }
        if (options.maxTimeMS != null) {
            this.maxTimeMS = options.maxTimeMS;
        }
        if (options.maxAwaitTimeMS != null) {
            this.maxAwaitTimeMS = options.maxAwaitTimeMS;
        }
        if (options.bypassDocumentValidation != null) {
            this.bypassDocumentValidation = options.bypassDocumentValidation;
        }
        if (options.collation != null) {
            this.collation = options.collation;
        }
        if (options.comment != null) {
            this.comment = options.comment;
        }
        if (options.hint != null) {
            this.hint = options.hint;
        }
    }

    public boolean isEmpty() {
        if (this.allowDiskUse != null) {
            return false;
        }
        if (this.maxTimeMS != null) {
            return false;
        }
        if (this.maxAwaitTimeMS != null) {
            return false;
        }
        if (this.bypassDocumentValidation != null) {
            return false;
        }
        if (this.collation != null) {
            return false;
        }
        if (this.comment != null) {
            return false;
        }
        return this.hint == null;
    }

    @Nullable
    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public MongoAggregationOptions allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Nullable
    public Long getMaxTimeMS() {
        return this.maxTimeMS;
    }

    public MongoAggregationOptions maxTimeMS(Long maxTimeMS) {
        this.maxTimeMS = maxTimeMS;
        return this;
    }

    @Nullable
    public Long getMaxAwaitTimeMS() {
        return this.maxAwaitTimeMS;
    }

    public MongoAggregationOptions maxAwaitTimeMS(Long maxAwaitTimeMS) {
        this.maxAwaitTimeMS = maxAwaitTimeMS;
        return this;
    }

    @Nullable
    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public MongoAggregationOptions bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public MongoAggregationOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public MongoAggregationOptions comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    public Bson getHint() {
        return this.hint;
    }

    public MongoAggregationOptions hint(Bson hint) {
        this.hint = hint;
        return this;
    }
}

