/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.serde;

import com.mongodb.MongoClientSettings;
import io.micronaut.configuration.mongo.core.AbstractMongoConfiguration;
import io.micronaut.configuration.mongo.core.CodecRegistryBuilder;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.mongodb.serde.DataCodecRegistry;
import io.micronaut.data.mongodb.serde.DataSerdeRegistry;
import io.micronaut.serde.annotation.Serdeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

@Prototype
@Internal
final class DataCodecRegistryBuilder
implements CodecRegistryBuilder {
    private final Environment environment;
    private final DataSerdeRegistry dataSerdeRegistry;
    private final RuntimeEntityRegistry runtimeEntityRegistry;

    DataCodecRegistryBuilder(Environment environment, DataSerdeRegistry dataSerdeRegistry, RuntimeEntityRegistry runtimeEntityRegistry) {
        this.environment = environment;
        this.dataSerdeRegistry = dataSerdeRegistry;
        this.runtimeEntityRegistry = runtimeEntityRegistry;
    }

    public CodecRegistry build(AbstractMongoConfiguration configuration) {
        List codecList;
        DataCodecRegistry dataCodecRegistry;
        ArrayList<CodecRegistry> codecRegistries = new ArrayList<CodecRegistry>();
        Collection packageNames = configuration.getPackageNames();
        if (CollectionUtils.isNotEmpty((Collection)packageNames)) {
            Collection entities = Stream.concat(this.environment.scan(Serdeable.Serializable.class, packageNames.toArray(new String[0])), this.environment.scan(Serdeable.Deserializable.class, packageNames.toArray(new String[0]))).collect(Collectors.toSet());
            dataCodecRegistry = new DataCodecRegistry(entities, this.dataSerdeRegistry, this.runtimeEntityRegistry);
        } else {
            dataCodecRegistry = new DataCodecRegistry(null, this.dataSerdeRegistry, this.runtimeEntityRegistry);
        }
        codecRegistries.add(dataCodecRegistry);
        codecRegistries.add(MongoClientSettings.getDefaultCodecRegistry());
        List configuredCodecRegistries = configuration.getCodecRegistries();
        if (configuredCodecRegistries != null) {
            codecRegistries.addAll(configuredCodecRegistries);
        }
        if ((codecList = configuration.getCodecs()) != null) {
            codecRegistries.add(CodecRegistries.fromCodecs((List)codecList));
        }
        return CodecRegistries.fromRegistries(codecRegistries);
    }
}

