/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.serde;

import io.micronaut.core.type.Argument;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.mongodb.serde.DataSerdeRegistry;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.bson.BsonReaderDecoder;
import io.micronaut.serde.bson.BsonWriterEncoder;
import java.io.IOException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

class MappedCodec<T>
implements Codec<T> {
    protected final DataSerdeRegistry dataSerdeRegistry;
    protected final RuntimePersistentEntity<T> persistentEntity;
    protected final Class<T> type;
    protected final Argument<T> argument;
    protected final Serializer<? super T> serializer;
    protected final Deserializer<? extends T> deserializer;
    protected final CodecRegistry codecRegistry;
    private final Deserializer.DecoderContext decoderContext;
    private final Serializer.EncoderContext encoderContext;

    MappedCodec(DataSerdeRegistry dataSerdeRegistry, RuntimePersistentEntity<T> persistentEntity, Class<T> type, CodecRegistry codecRegistry) {
        this.dataSerdeRegistry = dataSerdeRegistry;
        this.persistentEntity = persistentEntity;
        this.type = type;
        this.argument = Argument.of(type);
        this.codecRegistry = codecRegistry;
        this.decoderContext = dataSerdeRegistry.newDecoderContext(type, this.argument, persistentEntity, codecRegistry);
        this.encoderContext = dataSerdeRegistry.newEncoderContext(type, this.argument, persistentEntity, codecRegistry);
        try {
            this.serializer = dataSerdeRegistry.findSerializer(this.argument).createSpecific(this.encoderContext, this.argument);
            this.deserializer = dataSerdeRegistry.findDeserializer(this.argument).createSpecific(this.decoderContext, this.argument);
        }
        catch (IOException e) {
            throw new DataAccessException("Cannot find serialize/deserializer for type: " + type + ". " + e.getMessage(), (Throwable)e);
        }
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        try {
            return (T)this.deserializer.deserialize((Decoder)new BsonReaderDecoder(reader), this.decoderContext, this.argument);
        }
        catch (IOException e) {
            throw new DataAccessException("Cannot deserialize: " + this.type, (Throwable)e);
        }
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        try {
            this.serializer.serialize((Encoder)new BsonWriterEncoder(writer), this.encoderContext, this.argument, value);
        }
        catch (IOException e) {
            throw new DataAccessException("Cannot serialize: " + value, (Throwable)e);
        }
    }

    public Class<T> getEncoderClass() {
        return this.type;
    }
}

