/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.database;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import io.micronaut.configuration.mongo.core.DefaultMongoConfiguration;
import io.micronaut.configuration.mongo.core.NamedMongoConfiguration;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.mongodb.database.MongoDatabaseFactory;
import io.micronaut.data.mongodb.database.SimpleMongoDatabaseFactory;
import io.micronaut.data.mongodb.database.UnknownMongoDatabaseFactory;
import jakarta.inject.Singleton;

@Internal
@Factory
final class MongoFactory {
    MongoFactory() {
    }

    @Primary
    @Singleton
    MongoDatabaseFactory primaryMongoDatabaseFactory(DefaultMongoConfiguration mongoConfiguration, @Primary MongoClient mongoClient) {
        return mongoConfiguration.getConnectionString().map(ConnectionString::getDatabase).filter(StringUtils::isNotEmpty).map(databaseName -> new SimpleMongoDatabaseFactory(mongoClient, (String)databaseName)).orElseGet(UnknownMongoDatabaseFactory::new);
    }

    @EachBean(value=NamedMongoConfiguration.class)
    @Singleton
    MongoDatabaseFactory namedMongoDatabaseFactory(NamedMongoConfiguration mongoConfiguration, @Parameter MongoClient mongoClient) {
        return mongoConfiguration.getConnectionString().map(ConnectionString::getDatabase).filter(StringUtils::isNotEmpty).map(databaseName -> new SimpleMongoDatabaseFactory(mongoClient, (String)databaseName)).orElseGet(UnknownMongoDatabaseFactory::new);
    }
}

