/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import com.mongodb.client.model.Collation;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.mongodb.annotation.MongoRepository;
import io.micronaut.data.mongodb.operations.DefaultMongoPreparedQuery;
import io.micronaut.data.mongodb.operations.DefaultMongoStoredQuery;
import io.micronaut.data.mongodb.operations.MongoAggregation;
import io.micronaut.data.mongodb.operations.MongoFind;
import io.micronaut.data.mongodb.operations.MongoPreparedQuery;
import io.micronaut.data.mongodb.operations.MongoStoredQuery;
import io.micronaut.data.mongodb.operations.MongoUtils;
import io.micronaut.data.mongodb.operations.options.MongoAggregationOptions;
import io.micronaut.data.mongodb.operations.options.MongoFindOptions;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.repository.GenericRepository;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.operations.internal.AbstractRepositoryOperations;
import io.micronaut.data.runtime.query.DefaultPreparedQueryResolver;
import io.micronaut.data.runtime.query.DefaultStoredQueryResolver;
import io.micronaut.data.runtime.query.PreparedQueryResolver;
import io.micronaut.data.runtime.query.StoredQueryResolver;
import io.micronaut.data.runtime.query.internal.DefaultStoredQuery;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.slf4j.Logger;

@Internal
abstract class AbstractMongoRepositoryOperations<Dtb, Cnt, PS>
extends AbstractRepositoryOperations<Cnt, PS>
implements HintsCapableRepository,
PreparedQueryResolver,
StoredQueryResolver {
    protected static final Logger QUERY_LOG = DataSettings.QUERY_LOG;
    protected static final BsonDocument EMPTY = new BsonDocument();
    protected final Map<Class, String> repoDatabaseConfig;
    private final DefaultStoredQueryResolver defaultStoredQueryResolver = new DefaultStoredQueryResolver(){

        protected HintsCapableRepository getHintsCapableRepository() {
            return AbstractMongoRepositoryOperations.this;
        }
    };
    private final DefaultPreparedQueryResolver defaultPreparedQueryResolver = new DefaultPreparedQueryResolver(){

        protected ConversionService getConversionService() {
            return AbstractMongoRepositoryOperations.this.conversionService;
        }
    };

    protected AbstractMongoRepositoryOperations(String server, BeanContext beanContext, List<MediaTypeCodec> codecs, DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService<?> conversionService, AttributeConverterRegistry attributeConverterRegistry) {
        super(codecs, dateTimeProvider, runtimeEntityRegistry, conversionService, attributeConverterRegistry);
        Collection beanDefinitions = beanContext.getBeanDefinitions(GenericRepository.class, Qualifiers.byStereotype(MongoRepository.class));
        HashMap<Class, String> repoDatabaseConfig = new HashMap<Class, String>();
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String database;
            String targetSrv = beanDefinition.stringValue(Repository.class).orElse(null);
            if (targetSrv != null && !targetSrv.isEmpty() && !targetSrv.equalsIgnoreCase(server) || !StringUtils.isNotEmpty((CharSequence)(database = (String)beanDefinition.stringValue(MongoRepository.class, "databaseName").orElse(null)))) continue;
            repoDatabaseConfig.put(beanDefinition.getBeanType(), database);
        }
        this.repoDatabaseConfig = Collections.unmodifiableMap(repoDatabaseConfig);
    }

    protected abstract Dtb getDatabase(RuntimePersistentEntity<?> var1, Class<?> var2);

    protected abstract CodecRegistry getCodecRegistry(Dtb var1);

    protected <E, R> MongoStoredQuery<E, R, Dtb> getMongoStoredQuery(StoredQuery<E, R> storedQuery) {
        if (storedQuery instanceof MongoStoredQuery) {
            return (MongoStoredQuery)storedQuery;
        }
        throw new IllegalStateException("Expected for stored query to be of type: MongoStoredQuery");
    }

    protected <E, R> MongoPreparedQuery<E, R, Dtb> getMongoPreparedQuery(PreparedQuery<E, R> preparedQuery) {
        if (preparedQuery instanceof MongoPreparedQuery) {
            return (MongoPreparedQuery)preparedQuery;
        }
        throw new IllegalStateException("Expected for prepared query to be of type: MongoPreparedQuery");
    }

    public <E, R> PreparedQuery<E, R> resolveQuery(MethodInvocationContext<?, ?> context, StoredQuery<E, R> storedQuery, Pageable pageable) {
        PreparedQuery preparedQuery = this.defaultPreparedQueryResolver.resolveQuery(context, storedQuery, pageable);
        return new DefaultMongoPreparedQuery(preparedQuery);
    }

    public <E, R> PreparedQuery<E, R> resolveCountQuery(MethodInvocationContext<?, ?> context, StoredQuery<E, R> storedQuery, Pageable pageable) {
        PreparedQuery preparedQuery = this.defaultPreparedQueryResolver.resolveCountQuery(context, storedQuery, pageable);
        return new DefaultMongoPreparedQuery(preparedQuery);
    }

    public <E, R> StoredQuery<E, R> resolveQuery(MethodInvocationContext<?, ?> context, Class<E> entityClass, Class<R> resultType) {
        StoredQuery storedQuery = this.defaultStoredQueryResolver.resolveQuery(context, entityClass, resultType);
        RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(storedQuery.getRootEntity());
        Class repositoryType = ((DefaultStoredQuery)storedQuery).getMethod().getDeclaringType();
        Dtb database = this.getDatabase(persistentEntity, repositoryType);
        CodecRegistry codecRegistry = this.getCodecRegistry(database);
        return new DefaultMongoStoredQuery(storedQuery, codecRegistry, this.attributeConverterRegistry, this.runtimeEntityRegistry, (ConversionService<?>)this.conversionService, persistentEntity, database);
    }

    public <E, R> StoredQuery<E, R> resolveCountQuery(MethodInvocationContext<?, ?> context, Class<E> entityClass, Class<R> resultType) {
        StoredQuery storedQuery = this.defaultStoredQueryResolver.resolveCountQuery(context, entityClass, resultType);
        Class repositoryType = ((DefaultStoredQuery)storedQuery).getMethod().getDeclaringType();
        RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(storedQuery.getRootEntity());
        Dtb database = this.getDatabase(persistentEntity, repositoryType);
        CodecRegistry codecRegistry = this.getCodecRegistry(database);
        return new DefaultMongoStoredQuery(storedQuery, codecRegistry, this.attributeConverterRegistry, this.runtimeEntityRegistry, (ConversionService<?>)this.conversionService, persistentEntity, database);
    }

    public <E, QR> StoredQuery<E, QR> createStoredQuery(ExecutableMethod<?, ?> executableMethod, DataMethod.OperationType operationType, String name, AnnotationMetadata annotationMetadata, Class<Object> rootEntity, String query, String update, String[] queryParts, List<QueryParameterBinding> queryParameters, boolean hasPageable, boolean isSingleResult) {
        StoredQuery storedQuery = this.defaultStoredQueryResolver.createStoredQuery(executableMethod, operationType, name, annotationMetadata, rootEntity, query, update, queryParts, queryParameters, hasPageable, isSingleResult);
        Class repositoryType = executableMethod.getDeclaringType();
        RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(storedQuery.getRootEntity());
        Dtb database = this.getDatabase(persistentEntity, repositoryType);
        CodecRegistry codecRegistry = this.getCodecRegistry(database);
        return new DefaultMongoStoredQuery(storedQuery, codecRegistry, this.attributeConverterRegistry, this.runtimeEntityRegistry, (ConversionService<?>)this.conversionService, persistentEntity, database, operationType, update);
    }

    public StoredQuery<Object, Long> createCountStoredQuery(ExecutableMethod<?, ?> executableMethod, DataMethod.OperationType operationType, String name, AnnotationMetadata annotationMetadata, Class<Object> rootEntity, String query, String[] queryParts, List<QueryParameterBinding> queryParameters) {
        StoredQuery storedQuery = this.defaultStoredQueryResolver.createCountStoredQuery(executableMethod, operationType, name, annotationMetadata, rootEntity, query, queryParts, queryParameters);
        Class repositoryType = executableMethod.getDeclaringType();
        RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(storedQuery.getRootEntity());
        Dtb database = this.getDatabase(persistentEntity, repositoryType);
        CodecRegistry codecRegistry = this.getCodecRegistry(database);
        return new DefaultMongoStoredQuery(storedQuery, codecRegistry, this.attributeConverterRegistry, this.runtimeEntityRegistry, (ConversionService<?>)this.conversionService, persistentEntity, database, operationType, null);
    }

    protected <R> R convertResult(CodecRegistry codecRegistry, Class<R> resultType, BsonDocument result, boolean isDtoProjection) {
        BsonNull value;
        if (resultType == BsonDocument.class) {
            return (R)result;
        }
        if (result == null) {
            value = BsonNull.VALUE;
        } else if (result.size() == 1) {
            value = (BsonValue)result.values().iterator().next();
        } else if (result.size() == 2) {
            Optional<Map.Entry> id = result.entrySet().stream().filter(f -> !((String)f.getKey()).equals("_id")).findFirst();
            value = id.isPresent() ? (BsonValue)id.get().getValue() : (BsonValue)result.values().iterator().next();
        } else {
            if (isDtoProjection) {
                R dtoResult = MongoUtils.toValue(result.asDocument(), resultType, codecRegistry);
                if (resultType.isInstance(dtoResult)) {
                    return dtoResult;
                }
                return (R)this.conversionService.convertRequired(dtoResult, resultType);
            }
            throw new IllegalStateException("Unrecognized result: " + result);
        }
        return (R)this.conversionService.convertRequired(MongoUtils.toValue((BsonValue)value), resultType);
    }

    protected BsonDocument association(CodecRegistry codecRegistry, Object value, RuntimePersistentEntity<Object> persistentEntity, Object child, RuntimePersistentEntity<Object> childPersistentEntity) {
        BsonDocument document = new BsonDocument();
        document.put(persistentEntity.getPersistedName(), MongoUtils.entityIdValue(this.conversionService, persistentEntity, value, codecRegistry));
        document.put(childPersistentEntity.getPersistedName(), MongoUtils.entityIdValue(this.conversionService, childPersistentEntity, child, codecRegistry));
        return document;
    }

    protected ConversionContext createTypeConversionContext(Cnt connection, RuntimePersistentProperty<?> property, Argument<?> argument) {
        if (argument != null) {
            return ConversionContext.of(argument);
        }
        return ConversionContext.DEFAULT;
    }

    protected void logFind(MongoFind find) {
        StringBuilder sb = new StringBuilder();
        MongoFindOptions options = find.getOptions();
        if (options != null) {
            Collation collation;
            Bson projection;
            Bson sort;
            Bson filter = options.getFilter();
            if (filter != null) {
                sb.append(" filter: ").append(filter.toBsonDocument().toJson());
            }
            if ((sort = options.getSort()) != null) {
                sb.append(" sort: ").append(sort.toBsonDocument().toJson());
            }
            if ((projection = options.getProjection()) != null) {
                sb.append(" projection: ").append(projection.toBsonDocument().toJson());
            }
            if ((collation = options.getCollation()) != null) {
                sb.append(" collation: ").append(collation);
            }
        }
        if (sb.length() == 0) {
            QUERY_LOG.debug("Executing exists Mongo 'find'");
        } else {
            QUERY_LOG.debug("Executing exists Mongo 'find' with" + sb);
        }
    }

    protected void logAggregate(MongoAggregation aggregation) {
        MongoAggregationOptions options = aggregation.getOptions();
        StringBuilder sb = new StringBuilder();
        if (options != null) {
            sb.append(" pipeline: ").append(aggregation.getPipeline().stream().map(e -> e.toBsonDocument().toJson()).collect(Collectors.toList()));
            Collation collation = options.getCollation();
            if (collation != null) {
                sb.append(" collation: ").append(collation);
            }
        }
        QUERY_LOG.debug("Executing exists Mongo 'aggregate' with" + sb);
    }
}

