/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.repository.jpa.criteria;

import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.repository.jpa.criteria.SpecificationComposition;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import org.jspecify.annotations.Nullable;

public interface QuerySpecification<T> {
    public static final QuerySpecification<?> ALL = (root, query, criteriaBuilder) -> null;

    public static <T> QuerySpecification<T> not(@Nullable QuerySpecification<T> spec) {
        if (spec == null) {
            return ALL;
        }
        return (root, query, criteriaBuilder) -> criteriaBuilder.not((Expression)spec.toPredicate(root, query, criteriaBuilder));
    }

    public static <T> QuerySpecification<T> where(@Nullable QuerySpecification<T> spec) {
        if (spec == null) {
            return ALL;
        }
        return spec;
    }

    public static <T> QuerySpecification<T> where(@Nullable PredicateSpecification<T> spec) {
        if (spec == null) {
            return ALL;
        }
        return (root, query, criteriaBuilder) -> spec.toPredicate(root, criteriaBuilder);
    }

    default public QuerySpecification<T> and(@Nullable QuerySpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    default public QuerySpecification<T> or(@Nullable QuerySpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    default public QuerySpecification<T> and(@Nullable PredicateSpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    default public QuerySpecification<T> or(@Nullable PredicateSpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    public @Nullable Predicate toPredicate(Root<T> var1, CriteriaQuery<?> var2, CriteriaBuilder var3);
}

