/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations.reactive;

import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.convert.ConversionServiceProvider;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import org.reactivestreams.Publisher;

public interface ReactiveRepositoryOperations
extends ConversionServiceProvider {
    @SingleResult
    public <T> Publisher<T> findOne(Class<T> var1, Object var2);

    @SingleResult
    public <T> Publisher<Boolean> exists(PreparedQuery<T, Boolean> var1);

    @SingleResult
    public <T, R> Publisher<R> findOne(PreparedQuery<T, R> var1);

    @SingleResult
    public <T> Publisher<T> findOptional(Class<T> var1, Object var2);

    @SingleResult
    public <T, R> Publisher<R> findOptional(PreparedQuery<T, R> var1);

    public <T> Publisher<T> findAll(PagedQuery<T> var1);

    @SingleResult
    public <T> Publisher<Long> count(PagedQuery<T> var1);

    public <T, R> Publisher<R> findAll(PreparedQuery<T, R> var1);

    @SingleResult
    public <T> Publisher<T> persist(InsertOperation<T> var1);

    @SingleResult
    public <T> Publisher<T> update(UpdateOperation<T> var1);

    public <T> Publisher<T> updateAll(UpdateBatchOperation<T> var1);

    public <T> Publisher<T> persistAll(InsertBatchOperation<T> var1);

    @SingleResult
    public Publisher<Number> executeUpdate(PreparedQuery<?, Number> var1);

    @SingleResult
    default public Publisher<Number> executeDelete(PreparedQuery<?, Number> preparedQuery) {
        return this.executeUpdate(preparedQuery);
    }

    default public <R> Publisher<R> execute(PreparedQuery<?, R> preparedQuery) {
        throw new DataAccessException("Current repository: " + String.valueOf(this.getClass()) + " doesn't support method 'execute'!");
    }

    @SingleResult
    public <T> Publisher<Number> delete(DeleteOperation<T> var1);

    @SingleResult
    public <T> Publisher<Number> deleteAll(DeleteBatchOperation<T> var1);

    @SingleResult
    public <R> Publisher<Page<R>> findPage(PagedQuery<R> var1);
}

