/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations.reactive;

import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.reactive.ReactorReactiveCapableRepository;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public interface BlockingReactorRepositoryOperations
extends RepositoryOperations,
ReactorReactiveCapableRepository {
    private ContextView getContextView() {
        return ReactorPropagation.addPropagatedContext((Context)Context.empty(), (PropagatedContext)PropagatedContext.getOrEmpty());
    }

    @Override
    default public <T> @Nullable T findOne(Class<T> type, Object id) {
        return (T)this.reactive().findOne(type, id).contextWrite(this.getContextView()).block();
    }

    @Override
    default public <T, R> @Nullable R findOne(PreparedQuery<T, R> preparedQuery) {
        return (R)this.reactive().findOne(preparedQuery).contextWrite(this.getContextView()).block();
    }

    @Override
    default public <T, R> Iterable<R> findAll(PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.reactive().findAll(preparedQuery).contextWrite(this.getContextView()).collectList().block();
    }

    @Override
    default public <T, R> Stream<R> findStream(PreparedQuery<T, R> preparedQuery) {
        return this.reactive().findAll(preparedQuery).contextWrite(this.getContextView()).toStream();
    }

    @Override
    default public <T> T persist(InsertOperation<T> operation) {
        return (T)this.reactive().persist(operation).contextWrite(this.getContextView()).blockOptional().orElseGet(operation::getEntity);
    }

    @Override
    default public <T> T update(UpdateOperation<T> operation) {
        return (T)this.reactive().update(operation).contextWrite(this.getContextView()).blockOptional().orElseGet(operation::getEntity);
    }

    @Override
    default public <T> Iterable<T> updateAll(UpdateBatchOperation<T> operation) {
        return this.reactive().updateAll(operation).contextWrite(this.getContextView()).collectList().map(it -> it).blockOptional().orElse(operation);
    }

    @Override
    default public <T> Iterable<T> persistAll(InsertBatchOperation<T> operation) {
        return this.reactive().persistAll(operation).contextWrite(this.getContextView()).collectList().map(it -> it).blockOptional().orElse(operation);
    }

    @Override
    default public Optional<Number> executeUpdate(PreparedQuery<?, Number> preparedQuery) {
        return this.reactive().executeUpdate(preparedQuery).contextWrite(this.getContextView()).blockOptional();
    }

    @Override
    default public Optional<Number> executeDelete(PreparedQuery<?, Number> preparedQuery) {
        return this.reactive().executeDelete(preparedQuery).contextWrite(this.getContextView()).blockOptional();
    }

    @Override
    default public <R> List<R> execute(PreparedQuery<?, R> preparedQuery) {
        return (List)this.reactive().execute(preparedQuery).contextWrite(this.getContextView()).collectList().block();
    }

    @Override
    default public <T> int delete(DeleteOperation<T> operation) {
        return ((Number)this.reactive().delete(operation).contextWrite(this.getContextView()).blockOptional().orElse(0)).intValue();
    }

    @Override
    default public <T> Optional<Number> deleteAll(DeleteBatchOperation<T> operation) {
        return this.reactive().deleteAll(operation).contextWrite(this.getContextView()).blockOptional();
    }

    @Override
    default public <T> boolean exists(PreparedQuery<T, Boolean> preparedQuery) {
        return this.reactive().exists(preparedQuery).contextWrite(this.getContextView()).blockOptional().orElse(false);
    }

    @Override
    default public <R> Page<R> findPage(PagedQuery<R> query) {
        return (Page)this.reactive().findPage(query).contextWrite(this.getContextView()).block();
    }

    @Override
    default public <T> Iterable<T> findAll(PagedQuery<T> query) {
        return this.reactive().findAll(query).contextWrite(this.getContextView()).collectList().blockOptional().orElseGet(List::of);
    }

    @Override
    default public <T> long count(PagedQuery<T> pagedQuery) {
        return this.reactive().count(pagedQuery).contextWrite(this.getContextView()).blockOptional().orElse(0L);
    }

    @Override
    default public <T> Stream<T> findStream(PagedQuery<T> query) {
        return this.reactive().findAll(query).contextWrite(this.getContextView()).toStream();
    }
}

