/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations.async;

import io.micronaut.core.annotation.NonBlocking;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

@NonBlocking
public interface AsyncRepositoryOperations {
    public Executor getExecutor();

    public <T> CompletionStage<T> findOne(Class<T> var1, Object var2);

    public <T> CompletionStage<Boolean> exists(PreparedQuery<T, Boolean> var1);

    public <T, R> CompletionStage<R> findOne(PreparedQuery<T, R> var1);

    public <T> CompletionStage<T> findOptional(Class<T> var1, Object var2);

    public <T, R> CompletionStage<R> findOptional(PreparedQuery<T, R> var1);

    public <T> CompletionStage<Iterable<T>> findAll(PagedQuery<T> var1);

    public <T> CompletionStage<Long> count(PagedQuery<T> var1);

    public <T, R> CompletionStage<Iterable<R>> findAll(PreparedQuery<T, R> var1);

    public <T> CompletionStage<T> persist(InsertOperation<T> var1);

    public <T> CompletionStage<T> update(UpdateOperation<T> var1);

    default public <T> CompletionStage<Iterable<T>> updateAll(UpdateBatchOperation<T> operation) {
        throw new UnsupportedOperationException("The updateAll is required to be implemented.");
    }

    @SingleResult
    public <T> CompletionStage<Number> delete(DeleteOperation<T> var1);

    public <T> CompletionStage<Iterable<T>> persistAll(InsertBatchOperation<T> var1);

    public CompletionStage<Number> executeUpdate(PreparedQuery<?, Number> var1);

    default public CompletionStage<Number> executeDelete(PreparedQuery<?, Number> preparedQuery) {
        return this.executeUpdate(preparedQuery);
    }

    default public <R> CompletionStage<List<R>> execute(PreparedQuery<?, R> preparedQuery) {
        throw new DataAccessException("Current repository: " + String.valueOf(this.getClass()) + " doesn't support method 'execute'!");
    }

    public <T> CompletionStage<Number> deleteAll(DeleteBatchOperation<T> var1);

    public <R> CompletionStage<Page<R>> findPage(PagedQuery<R> var1);
}

