/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations;

import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.core.convert.ConversionServiceProvider;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.HintsCapableRepository;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public interface RepositoryOperations
extends HintsCapableRepository,
ApplicationContextProvider,
ConversionServiceProvider {
    default public <T> RuntimePersistentEntity<T> getEntity(Class<T> type) {
        return PersistentEntity.of(type);
    }

    public <T> @Nullable T findOne(Class<T> var1, Object var2);

    public <T, R> @Nullable R findOne(PreparedQuery<T, R> var1);

    public <T> boolean exists(PreparedQuery<T, Boolean> var1);

    public <T> Iterable<T> findAll(PagedQuery<T> var1);

    public <T> long count(PagedQuery<T> var1);

    public <T, R> Iterable<R> findAll(PreparedQuery<T, R> var1);

    public <T, R> Stream<R> findStream(PreparedQuery<T, R> var1);

    public <T> Stream<T> findStream(PagedQuery<T> var1);

    public <R> Page<R> findPage(PagedQuery<R> var1);

    public <T> T persist(InsertOperation<T> var1);

    public <T> T update(UpdateOperation<T> var1);

    default public <T> Iterable<T> updateAll(UpdateBatchOperation<T> operation) {
        return operation.split().stream().map(this::update).toList();
    }

    default public <T> Iterable<T> persistAll(InsertBatchOperation<T> operation) {
        return operation.split().stream().map(this::persist).toList();
    }

    public Optional<Number> executeUpdate(PreparedQuery<?, Number> var1);

    default public Optional<Number> executeDelete(PreparedQuery<?, Number> preparedQuery) {
        return this.executeUpdate(preparedQuery);
    }

    default public <R> List<R> execute(PreparedQuery<?, R> preparedQuery) {
        throw new DataAccessException("Current repository: " + String.valueOf(this.getClass()) + " doesn't support method 'execute'!");
    }

    public <T> int delete(DeleteOperation<T> var1);

    public <T> Optional<Number> deleteAll(DeleteBatchOperation<T> var1);
}

