/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.runtime;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Transient;
import io.micronaut.data.annotation.Version;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.AbstractPersistentEntity;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEmbedded;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimePersistentEntity<T>
extends AbstractPersistentEntity
implements PersistentEntity {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimePersistentEntity.class);
    private final BeanIntrospection<T> introspection;
    private final RuntimePersistentProperty<T>[] identity;
    private final RuntimePersistentProperty<T>[] allPersistentProperties;
    private final RuntimePersistentProperty<T>[] persistentProperties;
    private final RuntimePersistentProperty<T>[] constructorArguments;
    private final String aliasName;
    private final RuntimePersistentProperty<T> version;
    private Boolean hasAutoPopulatedProperties;
    private List<String> allPersistentPropertiesNames;
    private List<RuntimePersistentProperty<T>> persistentPropertiesValues;
    private EnumSet<Relation.Cascade> cascadedTypes;
    private BeanIntrospection<?> idClassIntrospection;

    public RuntimePersistentEntity(Class<T> type) {
        this(BeanIntrospection.getIntrospection(type));
    }

    public RuntimePersistentEntity(BeanIntrospection<T> introspection) {
        this(introspection, introspection.getBeanProperties());
    }

    public RuntimePersistentEntity(BeanIntrospection<T> introspection, Collection<BeanProperty<T, Object>> beanProperties) {
        super((AnnotationMetadataProvider)introspection);
        RuntimeAssociation prop;
        ArgumentUtils.requireNonNull((String)"introspection", introspection);
        this.introspection = introspection;
        Argument[] constructorArguments = introspection.getConstructorArguments();
        Set constructorArgumentNames = Arrays.stream(constructorArguments).map(Argument::getName).collect(Collectors.toSet());
        RuntimePersistentProperty<T> version = null;
        ArrayList<RuntimeEmbedded<T>> ids = new ArrayList<RuntimeEmbedded<T>>(5);
        this.allPersistentProperties = new RuntimePersistentProperty[beanProperties.size()];
        this.persistentProperties = new RuntimePersistentProperty[beanProperties.size()];
        for (BeanProperty<T, Object> bp : beanProperties) {
            if (bp.hasStereotype(Transient.class)) continue;
            int propertyIndex = introspection.propertyIndexOf(bp.getName());
            if (bp.hasStereotype(Id.class)) {
                RuntimePersistentProperty id = this.isEmbedded(bp) ? new RuntimeEmbedded<T>(this, bp, constructorArgumentNames.contains(bp.getName())) : new RuntimePersistentProperty<T>(this, bp, constructorArgumentNames.contains(bp.getName()));
                ids.add((RuntimeEmbedded<T>)id);
                this.allPersistentProperties[propertyIndex] = id;
                continue;
            }
            if (bp.hasStereotype(Version.class)) {
                version = new RuntimePersistentProperty<T>(this, bp, constructorArgumentNames.contains(bp.getName()));
                this.allPersistentProperties[propertyIndex] = version;
                continue;
            }
            prop = bp.hasAnnotation(Relation.class) ? (this.isEmbedded(bp) ? new RuntimeEmbedded<T>(this, bp, constructorArgumentNames.contains(bp.getName())) : new RuntimeAssociation<T>(this, bp, constructorArgumentNames.contains(bp.getName()))) : new RuntimeAssociation(this, bp, constructorArgumentNames.contains(bp.getName()));
            this.allPersistentProperties[propertyIndex] = prop;
            this.persistentProperties[propertyIndex] = prop;
        }
        this.identity = ids.toArray(new RuntimePersistentProperty[0]);
        this.version = version;
        this.constructorArguments = new RuntimePersistentProperty[constructorArguments.length];
        for (int i = 0; i < constructorArguments.length; ++i) {
            Argument constructorArgument = constructorArguments[i];
            String argumentName = constructorArgument.getName();
            prop = this.getPropertyByName(argumentName);
            if (prop == null) {
                throw new MappingException("Constructor argument [" + argumentName + "] for type [" + this.getName() + "] must have an associated getter");
            }
            this.constructorArguments[i] = prop;
        }
        this.aliasName = super.getAliasName();
    }

    @Override
    protected void logDebug(String message, Exception e) {
        LOG.debug(message, (Throwable)e);
    }

    private static EnumSet<Relation.Cascade> cascades(RuntimePersistentEntity<?> persistentEntity) {
        EnumSet<Relation.Cascade> cascades = EnumSet.noneOf(Relation.Cascade.class);
        for (RuntimeAssociation<?> association : persistentEntity.getAssociations()) {
            cascades.addAll(RuntimePersistentEntity.cascades(association));
        }
        cascades.remove((Object)Relation.Cascade.NONE);
        if (cascades.remove((Object)Relation.Cascade.ALL)) {
            EnumSet<Relation.Cascade> all = EnumSet.allOf(Relation.Cascade.class);
            all.remove((Object)Relation.Cascade.ALL);
            all.remove((Object)Relation.Cascade.NONE);
            return all;
        }
        return cascades;
    }

    private static EnumSet<Relation.Cascade> cascades(RuntimeAssociation<?> association) {
        if (association.getKind() == Relation.Kind.EMBEDDED) {
            return RuntimePersistentEntity.cascades(association.getAssociatedEntity());
        }
        return association.getCascadeTypes();
    }

    protected AttributeConverter<Object, Object> resolveConverter(Class<?> converterClass) {
        throw new MappingException("Converters not supported");
    }

    public boolean cascadesPersist() {
        return this.getCascadedTypes().contains((Object)Relation.Cascade.PERSIST);
    }

    public boolean cascadesUpdate() {
        return this.getCascadedTypes().contains((Object)Relation.Cascade.UPDATE);
    }

    private EnumSet<Relation.Cascade> getCascadedTypes() {
        if (this.cascadedTypes == null) {
            this.cascadedTypes = RuntimePersistentEntity.cascades(this);
        }
        return this.cascadedTypes;
    }

    public boolean hasPrePersistEventListeners() {
        return false;
    }

    public boolean hasPreRemoveEventListeners() {
        return false;
    }

    public boolean hasPreUpdateEventListeners() {
        return false;
    }

    public boolean hasPostPersistEventListeners() {
        return false;
    }

    public boolean hasPostUpdateEventListeners() {
        return false;
    }

    public boolean hasPostRemoveEventListeners() {
        return false;
    }

    public boolean hasPostLoadEventListeners() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getAliasName() {
        return this.aliasName;
    }

    public BeanIntrospection<T> getIntrospection() {
        return this.introspection;
    }

    @Override
    public String getName() {
        return this.introspection.getBeanType().getName();
    }

    @Override
    public boolean hasCompositeIdentity() {
        return this.identity.length > 1;
    }

    @Override
    public boolean hasIdentity() {
        return this.identity.length == 1;
    }

    public @Nullable RuntimePersistentProperty<T>[] getCompositeIdentity() {
        return this.identity.length > 1 ? this.identity : null;
    }

    @Override
    public @Nullable RuntimePersistentProperty<T> getIdentity() {
        return this.identity.length == 1 ? this.identity[0] : null;
    }

    @Override
    public List<PersistentProperty> getIdentityProperties() {
        return List.of(this.identity);
    }

    public List<RuntimePersistentProperty<T>> getRuntimeIdentityProperties() {
        return List.of(this.identity);
    }

    @Override
    public @Nullable RuntimePersistentProperty<T> getVersion() {
        return this.version;
    }

    public Collection<RuntimePersistentProperty<T>> getPersistentProperties() {
        if (this.persistentPropertiesValues == null) {
            this.persistentPropertiesValues = Arrays.stream(this.persistentProperties).filter(Objects::nonNull).toList();
        }
        return this.persistentPropertiesValues;
    }

    public Collection<RuntimeAssociation<T>> getAssociations() {
        return super.getAssociations();
    }

    @Override
    public @Nullable RuntimePersistentProperty<T> getPropertyByName(String name) {
        int propertyIndex = this.introspection.propertyIndexOf(name);
        if (propertyIndex == -1) {
            return null;
        }
        return this.allPersistentProperties[propertyIndex];
    }

    @Override
    public RuntimePersistentProperty<T> getPropertyByNameIgnoreCase(String name) {
        for (RuntimePersistentProperty<T> property : this.allPersistentProperties) {
            if (property == null || !property.getName().equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public @Nullable RuntimePersistentProperty<T> getIdentityByName(String name) {
        return (RuntimePersistentProperty)super.getIdentityByName(name);
    }

    public List<String> getPersistentPropertyNames() {
        if (this.allPersistentPropertiesNames == null) {
            this.allPersistentPropertiesNames = Arrays.stream(this.allPersistentProperties).filter(Objects::nonNull).map(RuntimePersistentProperty::getName).toList();
        }
        return this.allPersistentPropertiesNames;
    }

    @Override
    public boolean isOwningEntity(PersistentEntity owner) {
        return true;
    }

    @Override
    public @Nullable PersistentEntity getParentEntity() {
        return null;
    }

    private boolean isEmbedded(BeanProperty bp) {
        return bp.enumValue(Relation.class, Relation.Kind.class).orElse(null) == Relation.Kind.EMBEDDED;
    }

    protected RuntimePersistentEntity<T> getEntity(Class<T> type) {
        return PersistentEntity.of(type);
    }

    public RuntimePersistentProperty<T>[] getConstructorArguments() {
        return this.constructorArguments;
    }

    public boolean hasAutoPopulatedProperties() {
        if (this.hasAutoPopulatedProperties == null) {
            this.hasAutoPopulatedProperties = this.hasDirectAutoPopulated() || this.hasAutoPopulatedInEmbeddeds();
        }
        return this.hasAutoPopulatedProperties;
    }

    private boolean hasDirectAutoPopulated() {
        return Arrays.stream(this.allPersistentProperties).filter(Objects::nonNull).anyMatch(PersistentProperty::isAutoPopulated);
    }

    private boolean hasAutoPopulatedInEmbeddeds() {
        HashSet<Class> visited = new HashSet<Class>();
        visited.add(this.getIntrospection().getBeanType());
        return this.getAssociations().stream().filter(PersistentProperty::isEmbedded).map(a -> a.getProperty().getType()).filter(visited::add).anyMatch(type -> {
            BeanIntrospection embeddedIntrospection = BeanIntrospection.getIntrospection((Class)type);
            return RuntimePersistentEntity.hasAutoPopulatedInEmbedded(embeddedIntrospection, visited);
        });
    }

    private static boolean hasAutoPopulatedInEmbedded(BeanIntrospection<?> introspection, Set<Class<?>> visited) {
        for (BeanProperty bp : introspection.getBeanProperties()) {
            BeanIntrospection ei;
            Class type;
            if (bp.hasStereotype(Transient.class)) continue;
            AnnotationMetadata am = bp.getAnnotationMetadata();
            if (!am.hasAnnotation(GeneratedValue.class) && am.hasStereotype(AutoPopulated.class)) {
                return true;
            }
            Relation.Kind kind = am.enumValue(Relation.class, Relation.Kind.class).orElse(null);
            if (kind != Relation.Kind.EMBEDDED || !visited.add(type = bp.getType()) || !RuntimePersistentEntity.hasAutoPopulatedInEmbedded(ei = BeanIntrospection.getIntrospection((Class)type), visited)) continue;
            return true;
        }
        return false;
    }
}

