/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public interface QueryResult {
    public String getQuery();

    default public @Nullable String getUpdate() {
        return null;
    }

    @Deprecated(forRemoval=true, since="4.10")
    default public @Nullable String getAggregate() {
        return null;
    }

    public List<String> getQueryParts();

    default public Map<String, String> getParameters() {
        return this.getParameterBindings().stream().collect(Collectors.toMap(QueryParameterBinding::getKey, p -> String.join((CharSequence)".", p.getPropertyPath())));
    }

    default public Map<String, DataType> getParameterTypes() {
        return this.getParameterBindings().stream().collect(Collectors.toMap(p -> String.join((CharSequence)".", p.getPropertyPath()), QueryParameterBinding::getDataType, (d1, d2) -> d1));
    }

    public List<QueryParameterBinding> getParameterBindings();

    default public Map<String, String> getAdditionalRequiredParameters() {
        return Collections.emptyMap();
    }

    default public int getMax() {
        return -1;
    }

    default public long getOffset() {
        return 0L;
    }

    default public Sort getSort() {
        return Sort.UNSORTED;
    }

    default public Collection<JoinPath> getJoinPaths() {
        return Collections.emptyList();
    }

    public static QueryResult of(String query, List<QueryParameterBinding> parameterBindings) {
        return QueryResult.of(query, List.of(), parameterBindings);
    }

    public static QueryResult of(final String query, final List<String> queryParts, final List<QueryParameterBinding> parameterBindings, final Map<String, String> additionalRequiredParameters) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        ArgumentUtils.requireNonNull((String)"additionalRequiredParameters", additionalRequiredParameters);
        return new QueryResult(){

            @Override
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }

            @Override
            public Map<String, String> getAdditionalRequiredParameters() {
                return additionalRequiredParameters;
            }
        };
    }

    public static QueryResult of(final String query, final List<String> queryParts, final List<QueryParameterBinding> parameterBindings) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        return new QueryResult(){

            @Override
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }
        };
    }

    public static QueryResult of(String query, List<String> queryParts, List<QueryParameterBinding> parameterBindings, Map<String, String> additionalRequiredParameters, int max, long offset) {
        return QueryResult.of(query, queryParts, parameterBindings, additionalRequiredParameters, max, offset, Collections.emptyList());
    }

    public static QueryResult of(final String query, final List<String> queryParts, final List<QueryParameterBinding> parameterBindings, final Map<String, String> additionalRequiredParameters, final int max, final long offset, final @Nullable Collection<JoinPath> joinPaths) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        ArgumentUtils.requireNonNull((String)"additionalRequiredParameters", additionalRequiredParameters);
        return new QueryResult(){

            @Override
            public int getMax() {
                return max;
            }

            @Override
            public long getOffset() {
                return offset;
            }

            @Override
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }

            @Override
            public Map<String, String> getAdditionalRequiredParameters() {
                return additionalRequiredParameters;
            }

            @Override
            public Collection<JoinPath> getJoinPaths() {
                return joinPaths;
            }
        };
    }

    public static QueryResult of(final String query, final List<String> queryParts, final List<QueryParameterBinding> parameterBindings, final int max, final long offset, final @Nullable Collection<JoinPath> joinPaths) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        return new QueryResult(){

            @Override
            public int getMax() {
                return max;
            }

            @Override
            public long getOffset() {
                return offset;
            }

            @Override
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }

            @Override
            public Collection<JoinPath> getJoinPaths() {
                return joinPaths;
            }
        };
    }

    public static QueryResult of(final String query, final List<String> queryParts, final List<QueryParameterBinding> parameterBindings, final int max, final long offset, final Sort sort, final @Nullable Collection<JoinPath> joinPaths) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        return new QueryResult(){

            @Override
            public int getMax() {
                return max;
            }

            @Override
            public long getOffset() {
                return offset;
            }

            @Override
            public Sort getSort() {
                return sort;
            }

            @Override
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }

            @Override
            public Collection<JoinPath> getJoinPaths() {
                return joinPaths;
            }
        };
    }

    public static QueryResult of(final String query, final List<String> queryParts, final List<QueryParameterBinding> parameterBindings, final @Nullable Collection<JoinPath> joinPaths) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        return new QueryResult(){

            @Override
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }

            @Override
            public Collection<JoinPath> getJoinPaths() {
                return joinPaths;
            }
        };
    }
}

