/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.predicate;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import jakarta.persistence.criteria.Expression;
import org.jspecify.annotations.Nullable;

@Internal
public enum PredicateUnaryOp {
    IS_NULL,
    IS_NON_NULL,
    IS_TRUE,
    IS_FALSE,
    IS_EMPTY,
    IS_NOT_EMPTY;


    void validate(Expression<?> expression) {
        switch (this.ordinal()) {
            case 4: 
            case 5: {
                CriteriaUtils.requireStringExpression(expression);
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported predicate: " + String.valueOf((Object)this));
            }
        }
    }

    public @Nullable PredicateUnaryOp negate() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> IS_NON_NULL;
            case 1 -> IS_NULL;
            case 2 -> IS_FALSE;
            case 3 -> IS_TRUE;
            case 4 -> IS_NOT_EMPTY;
            case 5 -> IS_EMPTY;
        };
    }
}

