/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.AbstractExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.ClassExpressionType;
import io.micronaut.data.model.jpa.criteria.impl.expression.UnaryExpressionType;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.Expression;

@Internal
public final class UnaryExpression<E>
extends AbstractExpression<E> {
    private final UnaryExpressionType type;
    private final IExpression<?> expression;

    public UnaryExpression(Expression<?> expression, UnaryExpressionType type) {
        this(expression, type, null);
    }

    public UnaryExpression(Expression<?> expression, UnaryExpressionType type, @Nullable Class<E> expressionType) {
        super(expressionType == null ? ((IExpression)expression).getExpressionType() : new ClassExpressionType<E>(expressionType));
        this.expression = (IExpression)expression;
        this.type = type;
        type.validate(expression);
    }

    public UnaryExpressionType getType() {
        return this.type;
    }

    public Expression<?> getExpression() {
        return this.expression;
    }

    @Override
    public void visitExpression(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return "UnaryExpression{type=" + String.valueOf((Object)this.type) + ", expression=" + String.valueOf(this.expression) + "}";
    }
}

