/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentAssociationPath;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.Bindable;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;

@Internal
public class DefaultEmbeddedPersistentPropertyPath<T>
implements PersistentPropertyPath<T> {
    private final PersistentAssociationPath propertyPath;
    private final BiFunction<Path<?>, PersistentProperty, PersistentPropertyPath<?>> getPropertyFn;

    public DefaultEmbeddedPersistentPropertyPath(Association association, List<Association> associations, BiFunction<Path<?>, PersistentProperty, PersistentPropertyPath<?>> getPropertyFn) {
        this(new PersistentAssociationPath(associations, association), getPropertyFn);
    }

    public DefaultEmbeddedPersistentPropertyPath(PersistentAssociationPath propertyPath, BiFunction<Path<?>, PersistentProperty, PersistentPropertyPath<?>> getPropertyFn) {
        this.propertyPath = propertyPath;
        this.getPropertyFn = getPropertyFn;
        if (propertyPath.getAssociation() == null) {
            throw new IllegalArgumentException("Embedded association path must have an association: " + String.valueOf(propertyPath));
        }
        if (!propertyPath.getAssociation().isEmbedded()) {
            throw new IllegalArgumentException("Embedded association path must be have an embedded association: " + String.valueOf(propertyPath));
        }
    }

    private IllegalStateException inNotSupported() {
        return new IllegalStateException("Embedded association doesn't support IN predicate");
    }

    @Override
    public Predicate in(Object ... values) {
        throw this.inNotSupported();
    }

    @Override
    public Predicate in(Collection<?> values) {
        throw this.inNotSupported();
    }

    @Override
    public Predicate in(Expression<?> ... values) {
        throw this.inNotSupported();
    }

    @Override
    public Predicate in(Expression<Collection<?>> values) {
        throw this.inNotSupported();
    }

    @Override
    public Association getProperty() {
        return this.propertyPath.getProperty();
    }

    @Override
    public List<Association> getAssociations() {
        return this.propertyPath.getAssociations();
    }

    @Override
    public PersistentAssociationPath getPropertyPath() {
        return this.propertyPath;
    }

    public Bindable<T> getModel() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Path<?> getParentPath() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Class<? extends T>> type() {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public <Y> PersistentPropertyPath<Y> get(String attributeName) {
        Association association = this.propertyPath.getAssociation();
        PersistentProperty property = association.getAssociatedEntity().getPropertyByNameIgnoreCase(attributeName);
        if (property == null) {
            throw new IllegalArgumentException("Embedded association doesn't have a property with name: " + attributeName);
        }
        return this.getPropertyFn.apply(this, property);
    }

    @Override
    public Class<? extends T> getJavaType() {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public void visitExpression(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return "PersistentPropertyPath{" + String.valueOf(this.propertyPath) + "}";
    }
}

