/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityQuery;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

@Internal
public abstract class AbstractPersistentEntityCriteriaUpdate<T>
implements PersistentEntityCriteriaUpdate<T> {
    protected Predicate predicate;
    protected PersistentEntityRoot<T> entityRoot;
    protected Map<String, Object> updateValues = new LinkedHashMap<String, Object>();
    protected Selection<?> returning;

    @Override
    public PersistentEntity getPersistentEntity() {
        return this.entityRoot.getPersistentEntity();
    }

    @Override
    public QueryResult build(AnnotationMetadata annotationMetadata, QueryBuilder queryBuilder) {
        return queryBuilder.buildUpdate(annotationMetadata, new UpdateQueryDefinitionImpl(this.entityRoot.getPersistentEntity(), this.predicate, this.returning, this.updateValues));
    }

    @Override
    public abstract PersistentEntityRoot<T> from(Class<T> var1);

    @Override
    public abstract PersistentEntityRoot<T> from(PersistentEntity var1);

    @Override
    public PersistentEntityRoot<T> from(EntityType<T> entity) {
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        return null;
    }

    @Override
    public PersistentEntityRoot<T> getRoot() {
        return this.entityRoot;
    }

    @Override
    public <Y, X extends Y> PersistentEntityCriteriaUpdate<T> set(SingularAttribute<? super T, Y> attribute, X value) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public <Y> PersistentEntityCriteriaUpdate<T> set(SingularAttribute<? super T, Y> attribute, Expression<? extends Y> value) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public <Y, X extends Y> PersistentEntityCriteriaUpdate<T> set(Path<Y> attribute, X value) {
        this.setValue(CriteriaUtils.requireProperty(attribute).getPathAsString(), value);
        return this;
    }

    @Override
    public <Y> PersistentEntityCriteriaUpdate<T> set(Path<Y> attribute, Expression<? extends Y> value) {
        this.setValue(CriteriaUtils.requireProperty(attribute).getPathAsString(), CriteriaUtils.requireParameter(value));
        return this;
    }

    @Override
    public PersistentEntityCriteriaUpdate<T> set(String attributeName, Object value) {
        this.setValue(attributeName, value);
        return this;
    }

    protected void setValue(String attributeName, Object value) {
        this.updateValues.put(attributeName, value);
    }

    @Override
    public PersistentEntityCriteriaUpdate<T> where(Expression<Boolean> restriction) {
        if (restriction instanceof ConjunctionPredicate) {
            ConjunctionPredicate conjunctionPredicate = (ConjunctionPredicate)restriction;
            this.predicate = conjunctionPredicate;
        } else {
            this.predicate = new ConjunctionPredicate(Collections.singleton((IExpression)restriction));
        }
        return this;
    }

    @Override
    public PersistentEntityCriteriaUpdate<T> where(Predicate ... restrictions) {
        Objects.requireNonNull(restrictions);
        this.predicate = restrictions.length > 0 ? (restrictions.length == 1 ? restrictions[0] : new ConjunctionPredicate(((Stream)Arrays.stream(restrictions).sequential()).map(x -> (IExpression)x).toList())) : null;
        return this;
    }

    public final Predicate getRestriction() {
        return this.predicate;
    }

    @Override
    public <U> PersistentEntitySubquery<U> subquery(ExpressionType<U> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public final boolean hasVersionRestriction() {
        if (this.entityRoot.getPersistentEntity().getVersion() == null) {
            return false;
        }
        return CriteriaUtils.hasVersionPredicate(this.predicate);
    }

    public final Map<String, Object> getUpdateValues() {
        return this.updateValues;
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        return CriteriaUtils.extractPredicateParameters(this.predicate);
    }

    @Override
    public PersistentEntityCriteriaUpdate<T> returning(Selection<? extends T> selection) {
        Objects.requireNonNull(selection);
        this.returning = selection;
        return this;
    }

    @Override
    public PersistentEntityCriteriaUpdate<T> returningMulti(List<Selection<?>> selectionList) {
        Objects.requireNonNull(selectionList);
        this.returning = !selectionList.isEmpty() ? new CompoundSelection(selectionList) : null;
        return this;
    }

    private static final class UpdateQueryDefinitionImpl
    extends AbstractPersistentEntityQuery.BaseQueryDefinitionImpl
    implements QueryBuilder.UpdateQueryDefinition {
        private final Map<String, Object> propertiesToUpdate;
        private final Selection<?> returningSelection;

        public UpdateQueryDefinitionImpl(PersistentEntity persistentEntity, Predicate predicate, Selection<?> returningSelection, Map<String, Object> propertiesToUpdate) {
            super(persistentEntity, predicate, Map.of());
            this.propertiesToUpdate = propertiesToUpdate;
            this.returningSelection = returningSelection;
        }

        @Override
        public Map<String, Object> propertiesToUpdate() {
            return this.propertiesToUpdate;
        }

        @Override
        public Selection<?> returningSelection() {
            return this.returningSelection;
        }
    }
}

