/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaInsert;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.Set;

@Internal
public abstract class AbstractPersistentEntityCriteriaInsert<T>
implements PersistentEntityCriteriaInsert<T> {
    protected PersistentEntityRoot<T> entityRoot;
    private boolean returning;

    @Override
    public PersistentEntity getPersistentEntity() {
        return this.entityRoot.getPersistentEntity();
    }

    @Override
    public QueryResult build(AnnotationMetadata annotationMetadata, QueryBuilder queryBuilder) {
        return queryBuilder.buildInsert(annotationMetadata, new InsertQueryDefinitionImpl(this.entityRoot.getPersistentEntity(), this.returning));
    }

    @Override
    public PersistentEntityRoot<T> getRoot() {
        return this.entityRoot;
    }

    @Override
    public void setReturning() {
        this.returning = true;
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        return Set.of();
    }

    private record InsertQueryDefinitionImpl(PersistentEntity persistentEntity, boolean returning) implements QueryBuilder.InsertQueryDefinition
    {
    }
}

