/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityQuery;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

@Internal
public abstract class AbstractPersistentEntityCriteriaDelete<T>
implements PersistentEntityCriteriaDelete<T> {
    protected Predicate predicate;
    protected PersistentEntityRoot<T> entityRoot;
    protected Selection<?> returning;

    @Override
    public PersistentEntity getPersistentEntity() {
        return this.entityRoot.getPersistentEntity();
    }

    @Override
    public QueryResult build(AnnotationMetadata annotationMetadata, QueryBuilder queryBuilder) {
        return queryBuilder.buildDelete(annotationMetadata, new DeleteQueryDefinitionImpl(this.entityRoot.getPersistentEntity(), this.predicate, this.returning));
    }

    @Override
    public abstract PersistentEntityRoot<T> from(Class<T> var1);

    @Override
    public abstract PersistentEntityRoot<T> from(PersistentEntity var1);

    @Override
    public PersistentEntityRoot<T> from(EntityType<T> entity) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public PersistentEntityCriteriaDelete<T> where(Expression<Boolean> restriction) {
        if (restriction instanceof ConjunctionPredicate) {
            ConjunctionPredicate conjunctionPredicate = (ConjunctionPredicate)restriction;
            this.predicate = conjunctionPredicate;
        } else {
            this.predicate = new ConjunctionPredicate(Collections.singleton((IExpression)restriction));
        }
        return this;
    }

    @Override
    public PersistentEntityCriteriaDelete<T> where(Predicate ... restrictions) {
        Objects.requireNonNull(restrictions);
        this.predicate = restrictions.length > 0 ? (restrictions.length == 1 ? restrictions[0] : new ConjunctionPredicate(((Stream)Arrays.stream(restrictions).sequential()).map(x -> (IExpression)x).toList())) : null;
        return this;
    }

    @Override
    public PersistentEntityRoot<T> getRoot() {
        return this.entityRoot;
    }

    public Predicate getRestriction() {
        return this.predicate;
    }

    @Override
    public <U> PersistentEntitySubquery<U> subquery(ExpressionType<U> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public final boolean hasVersionRestriction() {
        if (this.entityRoot.getPersistentEntity().getVersion() == null) {
            return false;
        }
        return CriteriaUtils.hasVersionPredicate(this.predicate);
    }

    @Override
    public PersistentEntityCriteriaDelete<T> returning(Selection<? extends T> selection) {
        Objects.requireNonNull(selection);
        this.returning = selection;
        return this;
    }

    @Override
    public PersistentEntityCriteriaDelete<T> returningMulti(List<Selection<?>> selectionList) {
        Objects.requireNonNull(selectionList);
        this.returning = !selectionList.isEmpty() ? new CompoundSelection(selectionList) : null;
        return this;
    }

    @Override
    public PersistentEntityCriteriaDelete<T> returningMulti(Selection<?> ... selections) {
        Objects.requireNonNull(selections);
        this.returning = selections.length != 0 ? new CompoundSelection(List.of(selections)) : null;
        return this;
    }

    private static final class DeleteQueryDefinitionImpl
    extends AbstractPersistentEntityQuery.BaseQueryDefinitionImpl
    implements QueryBuilder.DeleteQueryDefinition {
        private final Selection<?> returningSelection;

        DeleteQueryDefinitionImpl(PersistentEntity persistentEntity, Predicate predicate, Selection<?> returningSelection) {
            super(persistentEntity, predicate, Map.of());
            this.returningSelection = returningSelection;
        }

        @Override
        public Selection<?> returningSelection() {
            return this.returningSelection;
        }
    }
}

