/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.data.model.DefaultSlice;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.serde.annotation.Serdeable;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import tools.jackson.databind.annotation.JsonDeserialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@TypeHint(value={Slice.class})
@JsonDeserialize(as=DefaultSlice.class)
@Serdeable
@DefaultImplementation(value=DefaultSlice.class)
public interface Slice<T>
extends Iterable<T> {
    public List<T> getContent();

    public Pageable getPageable();

    default public int getPageNumber() {
        return this.getPageable().getNumber();
    }

    default public boolean hasNext() {
        return this.getContent().size() == this.getSize();
    }

    default public boolean hasPrevious() {
        return this.getOffset() > 0L;
    }

    default public Pageable nextPageable() {
        return this.getPageable().next();
    }

    default public Pageable previousPageable() {
        return this.getPageable().previous();
    }

    default public long getOffset() {
        return this.getPageable().getOffset();
    }

    default public int getSize() {
        return this.getPageable().getSize();
    }

    default public boolean isEmpty() {
        return this.getContent().isEmpty();
    }

    @JsonIgnore
    default public Sort getSort() {
        return this.getPageable();
    }

    default public int getNumberOfElements() {
        return this.getContent().size();
    }

    @Override
    default public Iterator<T> iterator() {
        return this.getContent().iterator();
    }

    default public <T2> Slice<T2> map(Function<T, T2> function) {
        List<T2> content = this.getContent().stream().map(function).toList();
        return new DefaultSlice<T2>(content, this.getPageable());
    }

    @ReflectiveAccess
    public static <T2> Slice<T2> of(List<T2> content, Pageable pageable) {
        return new DefaultSlice<T2>(content, pageable);
    }
}

