/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.PersistentAssociationPath;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.naming.NamingStrategy;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;

public interface Association
extends PersistentProperty {
    default public String getAliasName() {
        Optional alias;
        AnnotationValue mappedProperty = this.getAnnotation(MappedProperty.class);
        if (mappedProperty != null && (alias = mappedProperty.stringValue("alias")).isPresent()) {
            return (String)alias.get();
        }
        return NamingStrategy.DEFAULT.mappedName(this.getName()) + "_";
    }

    default public boolean hasDeclaredAliasName() {
        AnnotationValue mappedProperty = this.getAnnotation(MappedProperty.class);
        return mappedProperty != null && mappedProperty.stringValue("alias").isPresent();
    }

    public PersistentEntity getAssociatedEntity();

    default public Optional<? extends Association> getInverseSide() {
        return this.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").flatMap(s -> {
            PersistentProperty persistentProperty = this.getAssociatedEntity().getPropertyByPath((String)s).orElse(null);
            if (persistentProperty instanceof Association) {
                Association association = (Association)persistentProperty;
                return Optional.of(association);
            }
            return Optional.empty();
        });
    }

    default public Optional<PersistentAssociationPath> getInversePathSide() {
        return this.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").flatMap(s -> {
            PersistentPropertyPath persistentPropertyPath = this.getAssociatedEntity().getPropertyPath((String)s);
            if (persistentPropertyPath instanceof PersistentAssociationPath) {
                PersistentAssociationPath persistentAssociationPath = (PersistentAssociationPath)persistentPropertyPath;
                return Optional.of(persistentAssociationPath);
            }
            return Optional.empty();
        });
    }

    default public boolean isBidirectional() {
        return this.getInverseSide().isPresent();
    }

    default public Relation.Kind getKind() {
        return this.findAnnotation(Relation.class).flatMap(av -> av.enumValue(Relation.Kind.class)).orElse(Relation.Kind.ONE_TO_ONE);
    }

    default public boolean isForeignKey() {
        Relation.Kind kind = this.getKind();
        return kind == Relation.Kind.ONE_TO_MANY || kind == Relation.Kind.MANY_TO_MANY || kind == Relation.Kind.ONE_TO_ONE && this.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").isPresent();
    }

    default public boolean doesCascade(Relation.Cascade ... types) {
        if (ArrayUtils.isEmpty((Object[])types)) {
            return false;
        }
        EnumSet<Relation.Cascade> cascadeTypes = this.getCascadeTypes();
        if (cascadeTypes.contains((Object)Relation.Cascade.ALL)) {
            return true;
        }
        if (cascadeTypes.contains((Object)Relation.Cascade.NONE)) {
            return false;
        }
        for (Relation.Cascade cascade : types) {
            if (!cascadeTypes.contains((Object)cascade)) continue;
            return true;
        }
        return false;
    }

    default public EnumSet<Relation.Cascade> getCascadeTypes() {
        Relation.Cascade[] cascades = (Relation.Cascade[])this.getAnnotationMetadata().enumValues(Relation.class, "cascade", Relation.Cascade.class);
        if (cascades.length == 0) {
            return EnumSet.noneOf(Relation.Cascade.class);
        }
        for (Relation.Cascade cascade : cascades) {
            if (cascade == Relation.Cascade.ALL) {
                return EnumSet.allOf(Relation.Cascade.class);
            }
            if (cascade != Relation.Cascade.NONE) continue;
            return EnumSet.noneOf(Relation.Cascade.class);
        }
        return EnumSet.copyOf(Arrays.asList(cascades));
    }
}

