/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.naming.NamingStrategy;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;

@Internal
public abstract class AbstractPersistentEntity
implements PersistentEntity {
    private static final Map<String, NamingStrategy> NAMING_STRATEGIES = new ConcurrentHashMap<String, NamingStrategy>(3);
    private final AnnotationMetadataProvider annotationMetadataProvider;
    private final @Nullable NamingStrategy namingStrategy;

    protected AbstractPersistentEntity(AnnotationMetadataProvider annotationMetadataProvider) {
        this.annotationMetadataProvider = annotationMetadataProvider;
        this.namingStrategy = this.getNamingStrategy(annotationMetadataProvider.getAnnotationMetadata());
    }

    protected void logDebug(String message, Exception e) {
        System.err.println(message + " " + e.getMessage());
    }

    @Override
    public String getAliasName() {
        return this.getAnnotationMetadata().stringValue(MappedEntity.class, "alias").orElseGet(() -> NamingStrategy.DEFAULT.mappedName(this.getSimpleName()) + "_");
    }

    private NamingStrategy getNamingStrategy(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.stringValue(io.micronaut.data.annotation.NamingStrategy.class).flatMap(className -> this.getNamingStrategy((String)className, this.getClass().getClassLoader())).orElse(null);
    }

    private Optional<NamingStrategy> getNamingStrategy(String className, ClassLoader classLoader) {
        NamingStrategy namingStrategy = NAMING_STRATEGIES.get(className);
        if (namingStrategy != null) {
            return Optional.of(namingStrategy);
        }
        try {
            BeanIntrospection beanIntrospection;
            Object o;
            Class namingStrategyClass = ClassUtils.forName((String)className, (ClassLoader)classLoader).orElse(null);
            if (namingStrategyClass != null && (o = (beanIntrospection = BeanIntrospection.getIntrospection((Class)namingStrategyClass)).instantiate()) instanceof NamingStrategy) {
                NamingStrategy ns = (NamingStrategy)o;
                NAMING_STRATEGIES.put(className, ns);
                return Optional.of(ns);
            }
        }
        catch (Exception e) {
            this.logDebug("Tried, but could not instantiate naming strategy: " + className, e);
        }
        Object o = InstantiationUtils.tryInstantiate((String)className, (ClassLoader)classLoader).orElse(null);
        if (o instanceof NamingStrategy) {
            NamingStrategy ns = o;
            NAMING_STRATEGIES.put(className, ns);
            return Optional.of(ns);
        }
        return Optional.empty();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadataProvider.getAnnotationMetadata();
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy == null ? NamingStrategy.DEFAULT : this.namingStrategy;
    }

    @Override
    public Optional<NamingStrategy> findNamingStrategy() {
        return Optional.ofNullable(this.namingStrategy);
    }

    @Override
    public String getPersistedName() {
        return this.getNamingStrategy().mappedName(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        AbstractPersistentEntity that = (AbstractPersistentEntity)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

