/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.EntityRepresentation;

@Internal
public final class DataAnnotationUtils {
    private DataAnnotationUtils() {
    }

    public static boolean hasJsonEntityRepresentationAnnotation(AnnotationMetadata annotationMetadata) {
        AnnotationValue entityRepresentationAnnotationValue = annotationMetadata.getAnnotation(EntityRepresentation.class);
        if (entityRepresentationAnnotationValue == null) {
            return false;
        }
        EntityRepresentation.Type type = (EntityRepresentation.Type)((Object)entityRepresentationAnnotationValue.getRequiredValue("type", EntityRepresentation.Type.class));
        if (type != EntityRepresentation.Type.COLUMN) {
            return false;
        }
        EntityRepresentation.ColumnType columnType = (EntityRepresentation.ColumnType)((Object)entityRepresentationAnnotationValue.getRequiredValue("columnType", EntityRepresentation.ColumnType.class));
        return columnType == EntityRepresentation.ColumnType.JSON;
    }
}

