/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.ParameterExpressionImpl;
import io.micronaut.data.model.jpa.criteria.impl.PropertyPathParameterBinding;
import io.micronaut.data.model.jpa.criteria.impl.SimpleParameterBinding;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.builder.QueryParameterBinding;

@Internal
final class DefaultParameterExpression<T>
extends ParameterExpressionImpl<T> {
    @NonNull
    private final Class<T> paramClass;
    @Nullable
    private final Object value;

    public DefaultParameterExpression(@NonNull Class<T> paramClass, @Nullable String name, @Nullable Object value) {
        super(paramClass, name);
        this.paramClass = paramClass;
        this.value = value;
    }

    @Override
    public QueryParameterBinding bind(BindingParameter.BindingContext bindingContext) {
        String name = bindingContext.getName() == null ? String.valueOf(bindingContext.getIndex()) : bindingContext.getName();
        PersistentPropertyPath outgoingQueryParameterProperty = bindingContext.getOutgoingQueryParameterProperty();
        if (outgoingQueryParameterProperty == null) {
            return new SimpleParameterBinding(name, DataType.forType(this.paramClass), bindingContext.isExpandable(), this.value);
        }
        return new PropertyPathParameterBinding(name, outgoingQueryParameterProperty, bindingContext.isExpandable(), this.value);
    }
}

