/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.AbstractExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.UnaryExpressionType;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.Expression;

@Internal
public final class UnaryExpression<E>
extends AbstractExpression<E> {
    private final UnaryExpressionType type;
    private final Expression<?> expression;

    public UnaryExpression(Expression<?> expression, UnaryExpressionType type) {
        this(expression, type, null);
    }

    public UnaryExpression(Expression<?> expression, UnaryExpressionType type, @Nullable Class<E> expressionType) {
        super(expressionType);
        this.expression = expression;
        this.type = type;
    }

    @Override
    public Class<E> getJavaType() {
        Class javaType = super.getJavaType();
        if (javaType == null) {
            return this.expression.getJavaType();
        }
        return javaType;
    }

    @NonNull
    public UnaryExpressionType getType() {
        return this.type;
    }

    @NonNull
    public Expression<?> getExpression() {
        return this.expression;
    }

    @Override
    public void visitExpression(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }
}

