/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.data.model.CursoredPageable;
import io.micronaut.data.model.DefaultCursoredPage;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.serde.annotation.Serdeable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@TypeHint(value={CursoredPage.class})
@JsonDeserialize(as=DefaultCursoredPage.class)
@Serdeable
@DefaultImplementation(value=DefaultCursoredPage.class)
public interface CursoredPage<T>
extends Page<T> {
    public static final CursoredPage<?> EMPTY = new DefaultCursoredPage(Collections.emptyList(), Pageable.unpaged(), Collections.emptyList(), null);

    @Override
    public boolean hasTotalSize();

    @Override
    public long getTotalSize();

    @Override
    default public int getTotalPages() {
        int size = this.getSize();
        return size == 0 ? 1 : (int)Math.ceil((double)this.getTotalSize() / (double)size);
    }

    @Override
    default public boolean hasNext() {
        Pageable pageable = this.getPageable();
        if (pageable.getMode() == Pageable.Mode.CURSOR_NEXT) {
            return this.getContent().size() == pageable.getSize();
        }
        return true;
    }

    @Override
    default public boolean hasPrevious() {
        Pageable pageable = this.getPageable();
        if (pageable.getMode() == Pageable.Mode.CURSOR_PREVIOUS) {
            return this.getContent().size() == pageable.getSize();
        }
        return true;
    }

    @Override
    default public CursoredPageable nextPageable() {
        Pageable pageable = this.getPageable();
        Pageable.Cursor cursor = this.getCursor(this.getCursors().size() - 1).orElse(pageable.cursor().orElse(null));
        return Pageable.afterCursor(cursor, pageable.getNumber() + 1, pageable.getSize(), pageable.getSort());
    }

    @Override
    default public CursoredPageable previousPageable() {
        Pageable pageable = this.getPageable();
        Pageable.Cursor cursor = this.getCursor(0).orElse(pageable.cursor().orElse(null));
        return Pageable.beforeCursor(cursor, Math.max(0, pageable.getNumber() - 1), pageable.getSize(), pageable.getSort());
    }

    @Override
    @NonNull
    default public <T2> CursoredPage<T2> map(Function<T, T2> function) {
        List content = this.getContent().stream().map(function).collect(Collectors.toList());
        return new DefaultCursoredPage(content, this.getPageable(), this.getCursors(), this.hasTotalSize() ? Long.valueOf(this.getTotalSize()) : null);
    }

    @JsonCreator
    @ReflectiveAccess
    @NonNull
    public static <T> CursoredPage<T> of(@JsonProperty(value="content") @NonNull List<T> content, @JsonProperty(value="pageable") @NonNull Pageable pageable, @JsonProperty(value="cursors") @Nullable List<Pageable.Cursor> cursors, @JsonProperty(value="totalSize") @Nullable Long totalSize) {
        return new DefaultCursoredPage<T>(content, pageable, cursors, totalSize);
    }

    public Optional<Pageable.Cursor> getCursor(int var1);

    public List<Pageable.Cursor> getCursors();

    @NonNull
    public static <T2> CursoredPage<T2> empty() {
        return EMPTY;
    }
}

