/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.sql.JoinColumns;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.builder.sql.Dialect;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

@Internal
final class SqlQueryBuilderUtils {
    static final String ANN_JOIN_TABLE = "io.micronaut.data.annotation.sql.JoinTable";
    static final String ANN_JOIN_COLUMNS = "io.micronaut.data.annotation.sql.JoinColumns";
    static final String SEQ_SUFFIX = "_seq";
    private static final String PREFIX = "${";
    private static final String SUFFIX = "}";

    private SqlQueryBuilderUtils() {
    }

    static String mapPersistedName(String persistedName, UnaryOperator<String> mapFunction) {
        if (StringUtils.isEmpty((CharSequence)persistedName)) {
            return persistedName;
        }
        StringBuilder sb = new StringBuilder();
        String value = persistedName;
        int i = value.indexOf(PREFIX);
        while (i > -1) {
            int suffixIdx;
            if (i > 0) {
                String rawSegment = value.substring(0, i);
                sb.append((String)mapFunction.apply(rawSegment));
            }
            if ((suffixIdx = (value = value.substring(i + PREFIX.length())).indexOf(SUFFIX)) <= -1) {
                throw new ConfigurationException("Incomplete placeholder definitions detected: " + persistedName);
            }
            String expr = value.substring(0, suffixIdx).trim();
            sb.append(PREFIX).append(expr).append(SUFFIX);
            value = value.substring(suffixIdx + SUFFIX.length());
            i = value.indexOf(PREFIX);
        }
        if (!value.isEmpty()) {
            sb.append((String)mapFunction.apply(value));
        }
        return sb.toString();
    }

    static String addTypeToColumn(PersistentProperty prop, String column, Dialect dialect, boolean required) {
        if (prop instanceof Association) {
            throw new IllegalStateException("Association is not supported here");
        }
        AnnotationMetadata annotationMetadata = prop.getAnnotationMetadata();
        String definition = annotationMetadata.stringValue(MappedProperty.class, "definition").orElse(null);
        DataType dataType = prop.getDataType();
        if (definition != null) {
            return (String)column + " " + definition;
        }
        OptionalInt precision = SqlQueryBuilderUtils.findPersistenceColumnValue(annotationMetadata, "precision");
        OptionalInt scale = SqlQueryBuilderUtils.findPersistenceColumnValue(annotationMetadata, "scale");
        switch (dataType) {
            case STRING: {
                int stringLength = annotationMetadata.findAnnotation("jakarta.validation.constraints.Size$List").flatMap(v -> {
                    Optional value = v.getValue(AnnotationValue.class);
                    return value;
                }).map(v -> v.intValue("max")).orElseGet(() -> SqlQueryBuilderUtils.findPersistenceColumnValue(annotationMetadata, "length")).orElse(255);
                column = (String)column + " VARCHAR(" + stringLength + ")";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case UUID: {
                column = dialect == Dialect.ORACLE || dialect == Dialect.MYSQL ? (String)column + " VARCHAR(36)" : (dialect == Dialect.SQL_SERVER ? (String)column + " UNIQUEIDENTIFIER" : (String)column + " UUID");
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case BOOLEAN: {
                if (dialect == Dialect.ORACLE) {
                    column = (String)column + " NUMBER(3)";
                    break;
                }
                if (dialect == Dialect.SQL_SERVER) {
                    column = (String)column + " BIT NOT NULL";
                    break;
                }
                column = (String)column + " BOOLEAN";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case TIMESTAMP: {
                if (dialect == Dialect.ORACLE) {
                    column = (String)column + " TIMESTAMP";
                    if (!required) break;
                    column = (String)column + " NOT NULL";
                    break;
                }
                if (dialect == Dialect.SQL_SERVER) {
                    column = (String)column + " DATETIME2";
                    if (!required) break;
                    column = (String)column + " NOT NULL";
                    break;
                }
                if (dialect == Dialect.MYSQL) {
                    column = (String)column + " TIMESTAMP(6) DEFAULT NOW(6)";
                    break;
                }
                column = (String)column + " TIMESTAMP";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case DATE: {
                column = (String)column + " DATE";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case TIME: {
                column = dialect == Dialect.ORACLE ? (String)column + " DATE " : (String)column + " TIME(6) ";
                if (!required) break;
                column = (String)column + " NOT NULL ";
                break;
            }
            case LONG: {
                column = dialect == Dialect.ORACLE ? (String)column + " NUMBER(19)" : (String)column + " BIGINT";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case CHARACTER: {
                column = (String)column + " CHAR(1)";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case INTEGER: {
                if (precision.isPresent()) {
                    String numericName = dialect == Dialect.ORACLE ? "NUMBER" : "NUMERIC";
                    column = (String)column + " " + numericName + "(" + precision.getAsInt() + ")";
                } else {
                    column = dialect == Dialect.ORACLE ? (String)column + " NUMBER(10)" : (dialect == Dialect.POSTGRES ? (String)column + " INTEGER" : (String)column + " INT");
                }
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case BIGDECIMAL: {
                if (precision.isPresent()) {
                    if (scale.isPresent()) {
                        String numericName = dialect == Dialect.ORACLE ? "NUMBER" : "NUMERIC";
                        column = (String)column + " " + numericName + "(" + precision.getAsInt() + "," + scale.getAsInt() + ")";
                    } else {
                        column = (String)column + " FLOAT(" + precision.getAsInt() + ")";
                    }
                } else {
                    column = dialect == Dialect.ORACLE ? (String)column + " FLOAT(126)" : (String)column + " DECIMAL";
                }
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case FLOAT: {
                if (precision.isPresent()) {
                    if (scale.isPresent()) {
                        String numericName = dialect == Dialect.ORACLE ? "NUMBER" : "NUMERIC";
                        column = (String)column + " " + numericName + "(" + precision.getAsInt() + "," + scale.getAsInt() + ")";
                    } else {
                        column = (String)column + " FLOAT(" + precision.getAsInt() + ")";
                    }
                } else {
                    column = dialect == Dialect.ORACLE || dialect == Dialect.SQL_SERVER ? (String)column + " FLOAT(53)" : (dialect == Dialect.POSTGRES ? (String)column + " REAL" : (String)column + " FLOAT");
                }
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case BYTE_ARRAY: {
                column = dialect == Dialect.POSTGRES ? (String)column + " BYTEA" : (dialect == Dialect.SQL_SERVER ? (String)column + " VARBINARY(MAX)" : (dialect == Dialect.ORACLE ? (String)column + " BLOB" : (String)column + " BLOB"));
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case DOUBLE: {
                if (precision.isPresent()) {
                    if (scale.isPresent()) {
                        String numericName = dialect == Dialect.ORACLE ? "NUMBER" : "NUMERIC";
                        column = (String)column + " " + numericName + "(" + precision.getAsInt() + "," + scale.getAsInt() + ")";
                    } else {
                        column = (String)column + " FLOAT(" + precision.getAsInt() + ")";
                    }
                } else {
                    column = dialect == Dialect.ORACLE ? (String)column + " FLOAT(23)" : (dialect == Dialect.MYSQL || dialect == Dialect.H2 ? (String)column + " DOUBLE" : (String)column + " DOUBLE PRECISION");
                }
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case SHORT: 
            case BYTE: {
                column = dialect == Dialect.ORACLE ? (String)column + " NUMBER(5)" : (dialect == Dialect.POSTGRES ? (String)column + " SMALLINT" : (String)column + " TINYINT");
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case JSON: {
                column = (String)column + SqlQueryBuilderUtils.jsonColumnDefinition(prop, dialect, required);
                break;
            }
            case STRING_ARRAY: 
            case CHARACTER_ARRAY: {
                column = (String)column + " VARCHAR(255) ARRAY";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case SHORT_ARRAY: {
                column = dialect == Dialect.POSTGRES ? (String)column + " SMALLINT ARRAY" : (String)column + " TINYINT ARRAY";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case INTEGER_ARRAY: {
                column = dialect == Dialect.POSTGRES || dialect == Dialect.H2 ? (String)column + " INTEGER ARRAY" : (String)column + " INT ARRAY";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case LONG_ARRAY: {
                column = (String)column + " BIGINT ARRAY";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case FLOAT_ARRAY: {
                column = dialect == Dialect.H2 || dialect == Dialect.POSTGRES ? (String)column + " REAL ARRAY" : (String)column + " FLOAT ARRAY";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case DOUBLE_ARRAY: {
                column = dialect == Dialect.POSTGRES || dialect == Dialect.H2 ? (String)column + " DOUBLE PRECISION ARRAY" : (String)column + " DOUBLE ARRAY";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            case BOOLEAN_ARRAY: {
                column = (String)column + " BOOLEAN ARRAY";
                if (!required) break;
                column = (String)column + " NOT NULL";
                break;
            }
            default: {
                if (prop.isEnum()) {
                    column = (String)column + " VARCHAR(255)";
                    if (!required) break;
                    column = (String)column + " NOT NULL";
                    break;
                }
                if (prop.isAssignable(Clob.class)) {
                    column = dialect == Dialect.POSTGRES ? (String)column + " TEXT" : (String)column + " CLOB";
                    if (!required) break;
                    column = (String)column + " NOT NULL";
                    break;
                }
                if (prop.isAssignable(Blob.class)) {
                    column = dialect == Dialect.POSTGRES ? (String)column + " BYTEA" : (String)column + " BLOB";
                    if (!required) break;
                    column = (String)column + " NOT NULL";
                    break;
                }
                throw new MappingException("Unable to create table column for property [" + prop.getName() + "] of entity [" + prop.getOwner().getName() + "] with unknown data type: " + String.valueOf((Object)dataType));
            }
        }
        return column;
    }

    static boolean isNotForeign(List<Association> associations) {
        for (Association association : associations) {
            if (association.getKind() == Relation.Kind.EMBEDDED) continue;
            return false;
        }
        return true;
    }

    @NonNull
    static List<String> getJoinedColumns(AnnotationMetadata annotationMetadata, boolean associationOwner, String columnType) {
        AnnotationValue joinTable = annotationMetadata.getAnnotation(ANN_JOIN_TABLE);
        if (joinTable != null) {
            return joinTable.getAnnotations(associationOwner ? "joinColumns" : "inverseJoinColumns").stream().flatMap(ann -> ann.stringValue(columnType).stream()).toList();
        }
        return Collections.emptyList();
    }

    @NonNull
    static List<String> resolveJoinTableJoinColumns(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = SqlQueryBuilderUtils.getJoinedColumns(annotationMetadata, associationOwner, "name");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        ArrayList<String> columns = new ArrayList<String>();
        PersistentProperty property1 = entity.getIdentity();
        PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), property1, (associations, property) -> columns.add(namingStrategy.mappedJoinTableColumn(entity, (List<Association>)associations, (PersistentProperty)property)));
        return columns;
    }

    static Stream<? extends PersistentProperty> flatMapEmbedded(PersistentProperty pp) {
        if (pp instanceof Embedded) {
            Embedded embedded = (Embedded)pp;
            PersistentEntity embeddedEntity = embedded.getAssociatedEntity();
            return embeddedEntity.getPersistentProperties().stream().flatMap(SqlQueryBuilderUtils::flatMapEmbedded);
        }
        return Stream.of(pp);
    }

    @NonNull
    static Collection<Association> getJoinTableAssociations(PersistentEntity persistentEntity) {
        return Stream.concat(Stream.of(persistentEntity.getIdentity()), persistentEntity.getPersistentProperties().stream()).flatMap(SqlQueryBuilderUtils::flatMapEmbedded).filter(p -> {
            if (p instanceof Association) {
                Association a = (Association)p;
                return SqlQueryBuilderUtils.isForeignKeyWithJoinTable(a);
            }
            return false;
        }).map(p -> (Association)p).toList();
    }

    static String getSchemaName(PersistentEntity entity) {
        return entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElseGet(() -> entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElse(null));
    }

    static OptionalInt findPersistenceColumnValue(AnnotationMetadata annotationMetadata, String value) {
        String annotationName = "javax.persistence.Column";
        OptionalInt optionalInt = annotationMetadata.intValue(annotationName, value);
        if (optionalInt.isEmpty()) {
            annotationName = "jakarta.persistence.Column";
            optionalInt = annotationMetadata.intValue(annotationName, value);
        }
        return optionalInt;
    }

    static boolean isForeignKeyWithJoinTable(@NonNull Association association) {
        if (!association.isForeignKey()) {
            return false;
        }
        if (association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").isPresent()) {
            return false;
        }
        AnnotationValue joinColumnsAnnotationValue = association.getAnnotationMetadata().getAnnotation(JoinColumns.class);
        return joinColumnsAnnotationValue == null || CollectionUtils.isEmpty((Collection)joinColumnsAnnotationValue.getAnnotations("value"));
    }

    static boolean isGeneratedProperty(PersistentProperty property, List<Association> associations) {
        Association last;
        PersistentEntity assocEntity;
        boolean generated = property.isGenerated();
        if (generated && generated && CollectionUtils.isNotEmpty(associations) && (assocEntity = (last = associations.get(associations.size() - 1)).getAssociatedEntity()) != null && assocEntity.getIdentityProperties().contains(property)) {
            generated = false;
        }
        return generated;
    }

    private static String jsonColumnDefinition(PersistentProperty prop, Dialect dialect, boolean required) {
        JsonDataType jsonDataType = prop.getJsonDataType();
        Object result = "";
        switch (dialect) {
            case POSTGRES: {
                result = (String)result + " JSONB";
                break;
            }
            case SQL_SERVER: {
                result = (String)result + " NVARCHAR(MAX)";
                break;
            }
            case ORACLE: {
                if (jsonDataType == JsonDataType.DEFAULT) {
                    result = (String)result + " JSON";
                    break;
                }
                if (jsonDataType == JsonDataType.BLOB) {
                    result = (String)result + " BLOB";
                    break;
                }
                result = (String)result + " CLOB";
                break;
            }
            default: {
                result = (String)result + " JSON";
            }
        }
        if (required) {
            result = (String)result + " NOT NULL";
        }
        return result;
    }
}

