/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.predicate;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import jakarta.persistence.criteria.Expression;

@Internal
public enum PredicateBinaryOp {
    EQUALS,
    NOT_EQUALS,
    EQUALS_IGNORE_CASE,
    NOT_EQUALS_IGNORE_CASE,
    GREATER_THAN,
    GREATER_THAN_OR_EQUALS,
    LESS_THAN,
    LESS_THAN_OR_EQUALS,
    REGEX,
    CONTAINS,
    CONTAINS_IGNORE_CASE,
    STARTS_WITH,
    ENDS_WITH,
    STARTS_WITH_IGNORE_CASE,
    ENDS_WITH_IGNORE_CASE,
    ARRAY_CONTAINS;


    void validate(@Nullable Expression<?> left, @Nullable Expression<?> right) {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                CriteriaUtils.requireComparableExpression(left);
                CriteriaUtils.requireComparableExpression(right);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                CriteriaUtils.requireStringExpression(left);
                CriteriaUtils.requireStringExpression(right);
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported predicate: " + String.valueOf((Object)this));
            }
        }
    }

    @Nullable
    public PredicateBinaryOp negate() {
        return switch (this.ordinal()) {
            case 0 -> NOT_EQUALS;
            case 1 -> EQUALS;
            default -> null;
        };
    }
}

