/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityQuery;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Selection;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Internal
public abstract class AbstractPersistentEntityCriteriaQuery<T>
extends AbstractPersistentEntityQuery<T, PersistentEntityCriteriaQuery<T>>
implements PersistentEntityCriteriaQuery<T> {
    protected AbstractPersistentEntityCriteriaQuery(ExpressionType<T> resultType, CriteriaBuilder criteriaBuilder) {
        super(resultType, criteriaBuilder);
    }

    @Override
    protected PersistentEntityCriteriaQuery<T> self() {
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> select(Selection<? extends T> selection) {
        this.selection = Objects.requireNonNull(selection);
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> multiselect(Selection<?> ... selections) {
        Objects.requireNonNull(selections);
        this.selection = selections.length > 0 ? new CompoundSelection(Arrays.asList(selections)) : null;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> multiselect(List<Selection<?>> selectionList) {
        Objects.requireNonNull(selectionList);
        this.selection = !selectionList.isEmpty() ? new CompoundSelection(selectionList) : null;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> orderBy(Order ... orders) {
        this.orders = Arrays.asList(Objects.requireNonNull(orders));
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> orderBy(List<Order> orders) {
        this.orders = Objects.requireNonNull(orders);
        return this;
    }

    public List<Order> getOrderList() {
        return this.orders;
    }

    public Set<ParameterExpression<?>> getParameters() {
        throw CriteriaUtils.notSupportedOperation();
    }
}

