/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.AbstractExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.ClassExpressionType;
import jakarta.persistence.criteria.Expression;
import java.util.List;

@Internal
public final class FunctionExpression<E>
extends AbstractExpression<E> {
    private final String name;
    private final List<Expression<?>> expressions;

    public FunctionExpression(String name, List<Expression<?>> expressions, @NonNull Class<E> expressionType) {
        super(new ClassExpressionType<E>(expressionType));
        this.name = name;
        this.expressions = expressions;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public List<Expression<?>> getExpressions() {
        return this.expressions;
    }

    @Override
    public void visitExpression(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return "FunctionExpression{name='" + this.name + "', expressions=" + this.expressions + "}";
    }
}

