/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.Collection;

public interface IExpression<T>
extends Expression<T>,
ISelection<T> {
    @NonNull
    public ExpressionType<T> getExpressionType();

    default public Class<? extends T> getJavaType() {
        return this.getExpressionType().getJavaType();
    }

    @NonNull
    default public Predicate isNull() {
        throw CriteriaUtils.notSupportedOperation();
    }

    @NonNull
    default public Predicate isNotNull() {
        throw CriteriaUtils.notSupportedOperation();
    }

    @NonNull
    default public Predicate in(Object ... values) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @NonNull
    default public Predicate in(Expression<?> ... values) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @NonNull
    default public Predicate in(Collection<?> values) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @NonNull
    default public Predicate in(Expression<Collection<?>> values) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @NonNull
    default public <X> Expression<X> as(Class<X> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public void visitExpression(ExpressionVisitor var1);

    @Override
    default public void visitSelection(SelectionVisitor selectionVisitor) {
        this.visitExpression(selectionVisitor);
    }
}

